/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.store;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.sdb.Store;
import org.apache.jena.sdb.core.SDBRequest;
import org.apache.jena.sdb.core.sqlexpr.SqlColumn;
import org.apache.jena.sdb.core.sqlnode.SqlTable;
import org.apache.jena.sdb.sql.RS;
import org.apache.jena.sdb.sql.ResultSetJDBC;
import org.apache.jena.sdb.sql.SDBExceptionSQL;
import org.apache.jena.sdb.store.SQLBridge;
import org.apache.jena.sdb.store.TableDesc;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.BindingRoot;
import org.apache.jena.sparql.util.Context;

public class TupleTable {
    private TableDesc desc;
    private Store store;
    private List<Var> vars;
    private SqlTable sqlTable;

    public TupleTable(Store store, String tableName) {
        this(store, TupleTable.getDesc(store, tableName));
    }

    public TupleTable(Store store, TableDesc desc) {
        this.store = store;
        this.desc = desc;
        this.sqlTable = new SqlTable(desc.getTableName(), desc.getTableName());
        this.vars = new ArrayList<Var>();
        desc.colNames().forEachRemaining(colName -> {
            Var var = Var.alloc(colName);
            this.vars.add(var);
            this.sqlTable.setIdColumnForVar(var, new SqlColumn(this.sqlTable, (String)colName));
        });
    }

    private static TableDesc getDesc(Store store, String tableName) {
        TableDesc tableDesc;
        ResultSetJDBC tableData = null;
        ArrayList<String> colVars = new ArrayList<String>();
        try {
            tableData = store.getConnection().execQuery("SELECT * FROM " + tableName);
            ResultSetMetaData meta = tableData.get().getMetaData();
            int N = meta.getColumnCount();
            for (int i = 1; i <= N; ++i) {
                String colName = meta.getColumnName(i);
                colVars.add(colName);
            }
            tableDesc = new TableDesc(tableName, colVars);
        }
        catch (SQLException ex) {
            try {
                throw new SDBExceptionSQL(ex);
            }
            catch (Throwable throwable) {
                RS.close(tableData);
                throw throwable;
            }
        }
        RS.close(tableData);
        return tableDesc;
    }

    public List<Var> getVars() {
        return this.vars;
    }

    public QueryIterator iterator() {
        SDBRequest request = new SDBRequest(this.store, null);
        String tableName = this.desc.getTableName();
        SQLBridge b = this.store.getSQLBridgeFactory().create(request, this.sqlTable, this.vars);
        b.build();
        try {
            String sqlStr = this.store.getSQLGenerator().generateSQL(request, b.getSqlNode());
            ResultSetJDBC tableData = this.store.getConnection().execQuery(sqlStr);
            ExecutionContext execCxt = new ExecutionContext(new Context(), null, null, null);
            return b.assembleResults(tableData, BindingRoot.create(), execCxt);
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL(ex);
        }
    }

    public void dump() {
        QueryIterator qIter = this.iterator();
        ResultSetFormatter.out(ResultSetFactory.create(qIter, Var.varNames(this.vars)));
    }
}

