/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra;

import java.util.Iterator;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.OpVisitorByType;
import org.apache.jena.sparql.algebra.op.Op0;
import org.apache.jena.sparql.algebra.op.Op1;
import org.apache.jena.sparql.algebra.op.Op2;
import org.apache.jena.sparql.algebra.op.OpExt;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpN;

public class OpWalker {
    public static void walk(Op op, OpVisitor visitor) {
        OpWalker.walk(new WalkerVisitor(visitor, null, null), op);
    }

    public static void walk(Op op, OpVisitor visitor, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        OpWalker.walk(new WalkerVisitor(visitor, beforeVisitor, afterVisitor), op);
    }

    public static void walk(WalkerVisitor walkerVisitor, Op op) {
        op.visit(walkerVisitor);
    }

    protected static class WalkerVisitor
    extends OpVisitorByType {
        private final OpVisitor beforeVisitor;
        private final OpVisitor afterVisitor;
        protected final OpVisitor visitor;

        public WalkerVisitor(OpVisitor visitor, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
            this.visitor = visitor;
            this.beforeVisitor = beforeVisitor;
            this.afterVisitor = afterVisitor;
        }

        public WalkerVisitor(OpVisitor visitor) {
            this(visitor, null, null);
        }

        protected final void before(Op op) {
            if (this.beforeVisitor != null) {
                op.visit(this.beforeVisitor);
            }
        }

        protected final void after(Op op) {
            if (this.afterVisitor != null) {
                op.visit(this.afterVisitor);
            }
        }

        @Override
        protected void visit0(Op0 op) {
            this.before(op);
            if (this.visitor != null) {
                op.visit(this.visitor);
            }
            this.after(op);
        }

        @Override
        protected void visit1(Op1 op) {
            this.before(op);
            if (op.getSubOp() != null) {
                op.getSubOp().visit(this);
            }
            if (this.visitor != null) {
                op.visit(this.visitor);
            }
            this.after(op);
        }

        @Override
        protected void visitFilter(OpFilter op) {
            this.visit1(op);
        }

        @Override
        protected void visitLeftJoin(OpLeftJoin op) {
            this.visit2(op);
        }

        @Override
        protected void visit2(Op2 op) {
            this.before(op);
            if (op.getLeft() != null) {
                op.getLeft().visit(this);
            }
            if (op.getRight() != null) {
                op.getRight().visit(this);
            }
            if (this.visitor != null) {
                op.visit(this.visitor);
            }
            this.after(op);
        }

        @Override
        protected void visitN(OpN op) {
            this.before(op);
            Iterator<Op> iter = op.iterator();
            while (iter.hasNext()) {
                Op sub = iter.next();
                sub.visit(this);
            }
            if (this.visitor != null) {
                op.visit(this.visitor);
            }
            this.after(op);
        }

        @Override
        protected void visitExt(OpExt op) {
            this.before(op);
            if (this.visitor != null) {
                op.visit(this.visitor);
            }
            this.after(op);
        }
    }
}

