/*
 * Decompiled with CFR 0.152.
 */
package tdb.tools;

import arq.cmdline.CmdARQ;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Node_Literal;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.tdb.StoreConnection;
import org.apache.jena.tdb.base.file.Location;
import org.apache.jena.tdb.setup.Build;
import org.apache.jena.tdb.store.DatasetGraphTDB;
import org.apache.jena.tdb.store.NodeId;
import org.apache.jena.tdb.store.nodetable.NodeTable;
import org.apache.jena.tdb.sys.Names;
import org.apache.jena.tdb.sys.SystemTDB;
import tdb.cmdline.ModLocation;

public class dumpnodetable
extends CmdARQ {
    ModLocation modLocation = new ModLocation();

    public static void main(String ... argv) {
        LogCtl.setLog4j();
        new dumpnodetable(argv).mainRun();
    }

    @Override
    protected void exec() {
        List<String> tripleIndexes = Arrays.asList(Names.tripleIndexes);
        List<String> quadIndexes = Arrays.asList(Names.quadIndexes);
        Location loc = this.modLocation.getLocation();
        StoreConnection sConn = StoreConnection.make(loc);
        DatasetGraphTDB dsg = sConn.getBaseDataset();
        NodeTable nodeTable = dsg.getQuadTable().getNodeTupleTable().getNodeTable();
        dumpnodetable.dump(System.out, nodeTable);
    }

    protected dumpnodetable(String[] argv) {
        super(argv);
        super.addModule(this.modLocation);
    }

    public static void dumpNodes(OutputStream w, String location) {
        dumpnodetable.dump(w, location, "node2id", SystemTDB.Node2NodeIdCacheSize, "nodes", SystemTDB.NodeId2NodeCacheSize, 100);
    }

    public static void dumpPrefixes(OutputStream w, String location) {
        dumpnodetable.dump(w, location, "prefix2id", 100, "prefixes", 100, 10);
    }

    public static void dump(OutputStream w, String location, String indexNode2Id, int node2NodeIdCacheSize, String indexId2Node, int nodeId2NodeCacheSize, int sizeNodeMissCacheSize) {
        NodeTable nodeTable = Build.makeNodeTable(Location.create(location), indexNode2Id, node2NodeIdCacheSize, indexId2Node, nodeId2NodeCacheSize, sizeNodeMissCacheSize);
    }

    public static void dump(OutputStream w, NodeTable nodeTable) {
        Iterator<Pair<NodeId, Node>> iter = nodeTable.all();
        long count = 0L;
        try (IndentedWriter iw = new IndentedWriter(w);){
            while (iter.hasNext()) {
                Pair<NodeId, Node> pair = iter.next();
                iw.print(pair.car().toString());
                iw.print(" : ");
                Node n = pair.cdr();
                String $ = dumpnodetable.stringForNode(n);
                iw.print($);
                iw.println();
                ++count;
            }
            iw.println();
            iw.printf("Total: " + count, new Object[0]);
            iw.println();
            iw.flush();
        }
    }

    private static String stringForNode(Node n) {
        if (n == null) {
            return "<<null>>";
        }
        if (n.isBlank()) {
            return "_:" + n.getBlankNodeLabel();
        }
        if (n.isLiteral()) {
            return dumpnodetable.stringForLiteral((Node_Literal)n);
        }
        if (n.isURI()) {
            String uri = n.getURI();
            return dumpnodetable.stringForURI(uri);
        }
        if (n.isVariable()) {
            return "?" + n.getName();
        }
        if (n.equals(Node.ANY)) {
            return "ANY";
        }
        Log.warn(FmtUtils.class, "Failed to turn a node into a string: " + n);
        return n.toString();
    }

    public static String stringForURI(String uri) {
        return "<" + uri + ">";
    }

    public static String stringForLiteral(Node_Literal literal) {
        String datatype = literal.getLiteralDatatypeURI();
        String lang = literal.getLiteralLanguage();
        String s = literal.getLiteralLexicalForm();
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("\"");
        FmtUtils.stringEsc(sbuff, s, true);
        sbuff.append("\"");
        if (lang != null && lang.length() > 0) {
            sbuff.append("@");
            sbuff.append(lang);
        }
        if (datatype != null) {
            sbuff.append("^^");
            sbuff.append(dumpnodetable.stringForURI(datatype));
        }
        return sbuff.toString();
    }

    @Override
    protected void processModulesAndArgs() {
        if (this.modVersion.getVersionFlag()) {
            this.modVersion.printVersionAndExit();
        }
        if (this.modLocation.getLocation() == null) {
            this.cmdError("Location required");
        }
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " --loc=DIR IndexName";
    }

    @Override
    protected String getCommandName() {
        return Lib.className(this);
    }
}

