/*
 * Decompiled with CFR 0.152.
 */
package arq;

import java.io.PrintStream;
import jena.cmd.ArgDecl;
import jena.cmd.CmdException;
import jena.cmd.CmdLineArgs;
import jena.cmd.TerminationException;
import org.apache.jena.Jena;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.sse.WriterSSE;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.system.JenaSystem;

public class qexpr {
    public static void main(String ... argv) {
        block3: {
            try {
                qexpr.main2(argv);
            }
            catch (TerminationException ex) {
                System.exit(ex.getCode());
            }
            catch (CmdException ex) {
                System.err.println(ex.getMessage());
                if (ex.getCause() == null) break block3;
                ex.getCause().printStackTrace(System.err);
            }
        }
    }

    public static void execAndReturn(String ... argv) {
        block3: {
            try {
                qexpr.main2(argv);
            }
            catch (TerminationException ex) {
                return;
            }
            catch (CmdException ex) {
                System.err.println(ex.getMessage());
                if (ex.getCause() == null) break block3;
                ex.getCause().printStackTrace(System.err);
            }
        }
    }

    public static void main2(String ... argv) {
        CmdLineArgs cl = new CmdLineArgs(argv);
        ArgDecl helpDecl = new ArgDecl(false, "h", "help");
        cl.add(helpDecl);
        ArgDecl verboseDecl = new ArgDecl(false, "v", "verbose");
        cl.add(verboseDecl);
        ArgDecl versionDecl = new ArgDecl(false, "ver", "version", "V");
        cl.add(versionDecl);
        ArgDecl quietDecl = new ArgDecl(false, "q", "quiet");
        cl.add(quietDecl);
        ArgDecl reduceDecl = new ArgDecl(false, "reduce", "fold", "simplify");
        cl.add(reduceDecl);
        ArgDecl strictDecl = new ArgDecl(false, "strict");
        cl.add(strictDecl);
        ArgDecl printDecl = new ArgDecl(true, "print");
        cl.add(printDecl);
        try {
            cl.process();
        }
        catch (IllegalArgumentException ex) {
            System.err.println(ex.getMessage());
            qexpr.usage(System.err);
            throw new CmdException();
        }
        if (cl.contains(helpDecl)) {
            qexpr.usage();
            throw new TerminationException(0);
        }
        if (cl.contains(versionDecl)) {
            System.out.println("ARQ Version: " + ARQ.VERSION + " (Jena: " + Jena.VERSION + ")");
            throw new TerminationException(0);
        }
        boolean verbose = cl.contains(verboseDecl);
        boolean quiet = cl.contains(quietDecl);
        if (cl.contains(strictDecl)) {
            ARQ.setStrictMode();
        }
        boolean actionCopySubstitute = cl.contains(reduceDecl);
        boolean actionPrintPrefix = false;
        boolean actionPrintSPARQL = false;
        boolean actionPrint = cl.contains(printDecl);
        for (String v : cl.getValues(printDecl)) {
            if (v.equalsIgnoreCase("prefix") || v.equalsIgnoreCase("op")) {
                actionPrintPrefix = true;
                continue;
            }
            if (v.equalsIgnoreCase("expr")) {
                actionPrintSPARQL = true;
                continue;
            }
            System.err.println("Unknown print form: " + v);
            throw new TerminationException(0);
        }
        for (int i = 0; i < cl.getNumPositional(); ++i) {
            String exprStr = cl.getPositionalArg(i);
            exprStr = cl.indirect(exprStr);
            try {
                PrefixMapping pmap = PrefixMapping.Factory.create();
                pmap.setNsPrefixes(ARQConstants.getGlobalPrefixMap());
                pmap.setNsPrefix("", "http://example/");
                pmap.setNsPrefix("ex", "http://example/ns#");
                Expr expr = ExprUtils.parse(exprStr, pmap);
                if (verbose) {
                    System.out.print(expr.toString() + " => ");
                }
                if (actionPrint) {
                    if (actionPrintSPARQL) {
                        System.out.println(ExprUtils.fmtSPARQL(expr));
                    }
                    if (actionPrintPrefix) {
                        WriterSSE.out(IndentedWriter.stdout, expr, new Prologue(pmap));
                    }
                    continue;
                }
                try {
                    if (actionCopySubstitute) {
                        Expr e2 = ExprLib.foldConstants(expr);
                        System.out.println(e2);
                        continue;
                    }
                    ARQ.getContext().set(ARQConstants.sysCurrentTime, NodeFactoryExtra.nowAsDateTime());
                    ExecutionContext env = new ExecutionContext(ARQ.getContext(), null, null, null);
                    NodeValue r = expr.eval(null, env);
                    Node n = r.asNode();
                    String s = NodeFmtLib.displayStr(n);
                    System.out.println(s);
                    continue;
                }
                catch (ExprEvalException ex) {
                    System.out.println("Exception: " + ex.getMessage());
                    throw new TerminationException(2);
                }
            }
            catch (QueryParseException ex) {
                System.err.println("Parse error: " + ex.getMessage());
                throw new TerminationException(2);
            }
        }
    }

    static void usage() {
        qexpr.usage(System.out);
    }

    static void usage(PrintStream out) {
        out.println("Usage: [--print=[prefix|expr]] expression");
    }

    static {
        LogCtl.setCmdLogging();
        JenaSystem.init();
    }
}

