/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.logging;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.slf4j.Logger;

public class LogCtl {
    private static String log4Jsetup = StrUtils.strjoinNL("## Command default log4j setup", "## Plain output with level, to stderr", "log4j.appender.jena.plainlevel=org.apache.log4j.ConsoleAppender", "log4j.appender.jena.plainlevel.target=System.err", "log4j.appender.jena.plainlevel.layout=org.apache.log4j.PatternLayout", "log4j.appender.jena.plainlevel.layout.ConversionPattern=%-5p %m%n", "## Everything", "log4j.rootLogger=INFO, jena.plainlevel", "log4j.logger.com.hp.hpl.jena=WARN", "log4j.logger.org.apache.jena=WARN", "log4j.logger.org.apache.jena.tdb.loader=INFO", "## Parser output", "log4j.additivity.org.apache.jena.riot=false", "log4j.logger.org.apache.jena.riot=INFO, jena.plainlevel");
    private static String defaultProperties = StrUtils.strjoinNL("handlers=org.apache.jena.atlas.logging.java.ConsoleHandlerStream");
    private static String JUL_LOGGING = "logging.properties";

    public static void set(Logger logger, String level) {
        LogCtl.setLevel(logger.getName(), level);
    }

    @Deprecated
    public static void set(Class<?> logger, String level) {
        LogCtl.setLevel(logger.getName(), level);
    }

    @Deprecated
    public static void set(String logger, String level) {
        LogCtl.setLevel(logger, level);
    }

    public static void setLevel(Class<?> logger, String level) {
        LogCtl.setLevel(logger.getName(), level);
    }

    public static void setLevel(String logger, String level) {
        LogCtl.setLevelLog4j(logger, level);
        LogCtl.setLevelJUL(logger, level);
    }

    private static void setLevelJUL(String logger, String levelName) {
        Level level = Level.ALL;
        if (levelName.equalsIgnoreCase("info")) {
            level = Level.INFO;
        } else if (levelName.equalsIgnoreCase("debug")) {
            level = Level.FINE;
        } else if (levelName.equalsIgnoreCase("warn") || levelName.equalsIgnoreCase("warning")) {
            level = Level.WARNING;
        } else if (levelName.equalsIgnoreCase("error")) {
            level = Level.SEVERE;
        } else if (levelName.equalsIgnoreCase("OFF")) {
            level = Level.OFF;
        }
        if (level != null) {
            java.util.logging.Logger.getLogger(logger).setLevel(level);
        }
    }

    private static void setLevelLog4j(String logger, String levelName) {
        try {
            org.apache.log4j.Level level = org.apache.log4j.Level.ALL;
            if (levelName.equalsIgnoreCase("info")) {
                level = org.apache.log4j.Level.INFO;
            } else if (levelName.equalsIgnoreCase("debug")) {
                level = org.apache.log4j.Level.DEBUG;
            } else if (levelName.equalsIgnoreCase("warn") || levelName.equalsIgnoreCase("warning")) {
                level = org.apache.log4j.Level.WARN;
            } else if (levelName.equalsIgnoreCase("error")) {
                level = org.apache.log4j.Level.ERROR;
            } else if (levelName.equalsIgnoreCase("OFF")) {
                level = org.apache.log4j.Level.OFF;
            }
            if (level != null) {
                LogManager.getLogger(logger).setLevel(level);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    @Deprecated
    public static void logLevel(String logger, org.apache.log4j.Level level1, Level level2) {
        if (level1 != null) {
            LogManager.getLogger(logger).setLevel(level1);
        }
        if (level2 != null) {
            java.util.logging.Logger.getLogger(logger).setLevel(level2);
        }
    }

    public static void enable(Logger logger) {
        LogCtl.enable(logger.getName());
    }

    public static void enable(String logger) {
        LogCtl.setLevel(logger, "all");
    }

    public static void enable(Class<?> logger) {
        LogManager.getLogger(logger).setLevel(org.apache.log4j.Level.ALL);
        java.util.logging.Logger.getLogger(logger.getName()).setLevel(Level.ALL);
    }

    public static void disable(String logger) {
        LogCtl.setLevel(logger, "OFF");
    }

    public static void disable(Class<?> logger) {
        LogCtl.setLevel(logger.getName(), "OFF");
    }

    public static void setInfo(String logger) {
        LogCtl.setLevel(logger, "info");
    }

    public static void setInfo(Class<?> logger) {
        LogCtl.setLevel(logger.getName(), "info");
    }

    public static void setWarn(String logger) {
        LogCtl.setLevel(logger, "warn");
    }

    public static void setWarn(Class<?> logger) {
        LogCtl.setLevel(logger.getName(), "warn");
    }

    public static void setError(String logger) {
        LogCtl.setLevel(logger, "error");
    }

    public static void setError(Class<?> logger) {
        LogCtl.setLevel(logger.getName(), "error");
    }

    public static void setLog4j() {
        String fn;
        File f;
        if (System.getProperty("log4j.configuration") == null && (f = new File(fn = "log4j.properties")).exists()) {
            System.setProperty("log4j.configuration", "file:" + fn);
        }
    }

    public static void setLog4j(String filename) {
        if (filename.toLowerCase().endsWith(".xml")) {
            DOMConfigurator.configure(filename);
        } else {
            PropertyConfigurator.configure(filename);
        }
    }

    public static void setCmdLogging() {
        LogCtl.setCmdLogging(log4Jsetup);
    }

    public static void setCmdLogging(String defaultConfig) {
        if (System.getProperty("log4j.configuration") == null) {
            LogCtl.resetLogging(defaultConfig);
        }
    }

    public static void resetLogging(String config) {
        Properties p = new Properties();
        ByteArrayInputStream in = new ByteArrayInputStream(StrUtils.asUTF8bytes(config));
        try {
            p.load(in);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PropertyConfigurator.configure(p);
        System.setProperty("log4j.configuration", "set");
    }

    public static void setJavaLogging() {
        Path p = Paths.get(JUL_LOGGING, new String[0]);
        if (Files.exists(p, new LinkOption[0])) {
            LogCtl.setJavaLogging(JUL_LOGGING);
        } else {
            LogCtl.setJavaLoggingDft();
        }
    }

    public static void setJavaLogging(String file) {
        try {
            InputStream details = new FileInputStream(file);
            details = new BufferedInputStream(details);
            java.util.logging.LogManager.getLogManager().readConfiguration(details);
        }
        catch (Exception ex) {
            throw new AtlasException(ex);
        }
    }

    public static void setJavaLoggingDft() {
        try {
            ByteArrayInputStream details = new ByteArrayInputStream(defaultProperties.getBytes("UTF-8"));
            java.util.logging.LogManager.getLogManager().readConfiguration(details);
        }
        catch (Exception ex) {
            throw new AtlasException(ex);
        }
    }
}

