/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfconnection;

import org.apache.jena.query.Dataset;
import org.apache.jena.rdfconnection.Isolation;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionLocal;
import org.apache.jena.rdfconnection.RDFConnectionRemote;
import org.apache.jena.system.JenaSystem;

public class RDFConnectionFactory {
    public static RDFConnection connect(String destination) {
        return new RDFConnectionRemote(destination);
    }

    public static RDFConnection connect(String queryServiceEndpoint, String updateServiceEndpoint, String graphStoreProtocolEndpoint) {
        return new RDFConnectionRemote(queryServiceEndpoint, updateServiceEndpoint, graphStoreProtocolEndpoint);
    }

    public static RDFConnection connect(String datasetURL, String queryServiceEndpoint, String updateServiceEndpoint, String graphStoreProtocolEndpoint) {
        return new RDFConnectionRemote(datasetURL, queryServiceEndpoint, updateServiceEndpoint, graphStoreProtocolEndpoint);
    }

    public static RDFConnection connect(Dataset dataset) {
        return new RDFConnectionLocal(dataset);
    }

    public static RDFConnection connect(Dataset dataset, Isolation isolation) {
        return new RDFConnectionLocal(dataset, isolation);
    }

    static {
        JenaSystem.init();
    }
}

