/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfconnection;

import java.io.File;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.protocol.HttpContext;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdfconnection.RDFConn;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.web.HttpCaptureResponse;
import org.apache.jena.riot.web.HttpOp;
import org.apache.jena.riot.web.HttpResponseLib;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.update.UpdateExecutionFactory;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;

public class RDFConnectionRemote
implements RDFConnection {
    private static final String fusekiDftSrvQuery = "sparql";
    private static final String fusekiDftSrvUpdate = "update";
    private static final String fusekiDftSrvGSP = "data";
    private boolean isOpen = true;
    private final String destination;
    private final String svcQuery;
    private final String svcUpdate;
    private final String svcGraphStore;
    private HttpClient httpClient;
    private HttpContext httpContext = null;
    private TxnLifecycle inner = new TxnLifecycle();

    public RDFConnectionRemote(HttpClient httpClient, String destination) {
        this(httpClient, Objects.requireNonNull(destination), fusekiDftSrvQuery, fusekiDftSrvUpdate, fusekiDftSrvGSP);
    }

    public RDFConnectionRemote(String destination) {
        this(Objects.requireNonNull(destination), fusekiDftSrvQuery, fusekiDftSrvUpdate, fusekiDftSrvGSP);
    }

    public RDFConnectionRemote(String sQuery, String sUpdate, String sGSP) {
        this(null, sQuery, sUpdate, sGSP);
    }

    public RDFConnectionRemote(String destination, String sQuery, String sUpdate, String sGSP) {
        this(null, destination, sQuery, sUpdate, sGSP);
    }

    public RDFConnectionRemote(HttpClient httpClient, String destination, String sQuery, String sUpdate, String sGSP) {
        this.destination = destination;
        this.svcQuery = RDFConn.formServiceURL(destination, sQuery);
        this.svcUpdate = RDFConn.formServiceURL(destination, sUpdate);
        this.svcGraphStore = RDFConn.formServiceURL(destination, sGSP);
        this.httpClient = httpClient;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    @Override
    public QueryExecution query(Query query2) {
        this.checkQuery();
        return RDFConnectionRemote.exec(() -> QueryExecutionFactory.sparqlService(this.svcQuery, query2, this.httpClient, this.httpContext));
    }

    @Override
    public void update(UpdateRequest update2) {
        this.checkUpdate();
        UpdateProcessor proc = UpdateExecutionFactory.createRemote(update2, this.svcUpdate, this.httpClient, this.httpContext);
        RDFConnectionRemote.exec(() -> proc.execute());
    }

    @Override
    public Model fetch(String graphName) {
        this.checkGSP();
        String url = RDFConn.urlForGraph(this.svcGraphStore, graphName);
        Graph graph = this.fetch$(url);
        return ModelFactory.createModelForGraph(graph);
    }

    @Override
    public Model fetch() {
        this.checkGSP();
        return this.fetch(null);
    }

    private Graph fetch$(String url) {
        HttpCaptureResponse<Graph> graph = HttpResponseLib.graphHandler();
        RDFConnectionRemote.exec(() -> HttpOp.execHttpGet(url, "text/turtle,application/n-triples;q=0.9,application/ld+json;q=0.8,application/rdf+xml;q=0.7,*/*;q=0.5", graph, this.httpClient, this.httpContext));
        return graph.get();
    }

    @Override
    public void load(String graph, String file) {
        this.checkGSP();
        this.upload(graph, file, false);
    }

    @Override
    public void load(String file) {
        this.checkGSP();
        this.upload(null, file, false);
    }

    @Override
    public void load(Model model) {
        this.doPutPost(model, null, false);
    }

    @Override
    public void load(String graphName, Model model) {
        this.doPutPost(model, graphName, false);
    }

    @Override
    public void put(String graph, String file) {
        this.checkGSP();
        this.upload(graph, file, true);
    }

    @Override
    public void put(String file) {
        this.checkGSP();
        this.upload(null, file, true);
    }

    @Override
    public void put(String graphName, Model model) {
        this.checkGSP();
        this.doPutPost(model, graphName, true);
    }

    @Override
    public void put(Model model) {
        this.checkGSP();
        this.doPutPost(model, null, true);
    }

    protected void upload(String graph, String file, boolean replace) {
        Lang lang = RDFLanguages.filenameToLang(file);
        if (RDFLanguages.isQuads(lang)) {
            throw new ARQException("Can't load quads into a graph");
        }
        if (!RDFLanguages.isTriples(lang)) {
            throw new ARQException("Not an RDF format: " + file + " (lang=" + lang + ")");
        }
        String url = RDFConn.urlForGraph(this.svcGraphStore, graph);
        this.doPutPost(url, file, lang, replace);
    }

    protected void doPutPost(String url, String file, Lang lang, boolean replace) {
        File f = new File(file);
        long length = f.length();
        InputStream source = IO.openFile(file);
        RDFConnectionRemote.exec(() -> {
            if (replace) {
                HttpOp.execHttpPut(url, lang.getContentType().getContentType(), source, length, this.httpClient, this.httpContext);
            } else {
                HttpOp.execHttpPost(url, lang.getContentType().getContentType(), source, length, null, null, this.httpClient, this.httpContext);
            }
        });
    }

    protected void doPutPost(Model model, String name, boolean replace) {
        String url = RDFConn.urlForGraph(this.svcGraphStore, name);
        RDFConnectionRemote.exec(() -> {
            Graph graph = model.getGraph();
            if (replace) {
                HttpOp.execHttpPut(url, this.graphToHttpEntity(graph), this.httpClient, this.httpContext);
            } else {
                HttpOp.execHttpPost(url, this.graphToHttpEntity(graph), null, null, this.httpClient, this.httpContext);
            }
        });
    }

    @Override
    public void delete(String graph) {
        this.checkGSP();
        String url = RDFConn.urlForGraph(this.svcGraphStore, graph);
        RDFConnectionRemote.exec(() -> HttpOp.execHttpDelete(url));
    }

    @Override
    public void delete() {
        this.checkGSP();
        this.delete(null);
    }

    @Override
    public Dataset fetchDataset() {
        this.checkDataset();
        DatasetGraph dsg = this.fetchDataset$();
        return DatasetFactory.wrap(dsg);
    }

    private DatasetGraph fetchDataset$() {
        HttpCaptureResponse<DatasetGraph> dsg = HttpResponseLib.datasetHandler();
        RDFConnectionRemote.exec(() -> HttpOp.execHttpGet(this.destination, "application/trig,application/n-quads;q=0.9,text/x-nquads;q=0.8,application/x-trig;q=0.7,application/ld+json;q=0.5,*/*;q=0.5", dsg, this.httpClient, this.httpContext));
        return dsg.get();
    }

    @Override
    public void loadDataset(String file) {
        this.checkDataset();
        this.doPutPostDataset(file, false);
    }

    @Override
    public void loadDataset(Dataset dataset) {
        this.checkDataset();
        this.doPutPostDataset(dataset, false);
    }

    @Override
    public void putDataset(String file) {
        if (this.destination == null) {
            throw new ARQException("Dataset operations not available - no dataset URl provided");
        }
        this.doPutPostDataset(file, true);
    }

    @Override
    public void putDataset(Dataset dataset) {
        if (this.destination == null) {
            throw new ARQException("Dataset operations not available - no dataset URl provided");
        }
        this.doPutPostDataset(dataset, true);
    }

    protected void doPutPostDataset(String file, boolean replace) {
        Lang lang = RDFLanguages.filenameToLang(file);
        File f = new File(file);
        long length = f.length();
        RDFConnectionRemote.exec(() -> {
            InputStream source = IO.openFile(file);
            if (replace) {
                HttpOp.execHttpPut(this.destination, lang.getContentType().getContentType(), source, length, this.httpClient, this.httpContext);
            } else {
                HttpOp.execHttpPost(this.destination, lang.getContentType().getContentType(), source, length, null, null, this.httpClient, this.httpContext);
            }
        });
    }

    protected void doPutPostDataset(Dataset dataset, boolean replace) {
        RDFConnectionRemote.exec(() -> {
            DatasetGraph dsg = dataset.asDatasetGraph();
            if (replace) {
                HttpOp.execHttpPut(this.destination, this.datasetToHttpEntity(dsg), this.httpClient, null);
            } else {
                HttpOp.execHttpPost(this.destination, this.datasetToHttpEntity(dsg), this.httpClient, null);
            }
        });
    }

    private void checkQuery() {
        this.checkOpen();
        if (this.svcQuery == null) {
            throw new ARQException("No query service defined for this RDFConnection");
        }
    }

    private void checkUpdate() {
        this.checkOpen();
        if (this.svcUpdate == null) {
            throw new ARQException("No update service defined for this RDFConnection");
        }
    }

    private void checkGSP() {
        this.checkOpen();
        if (this.svcGraphStore == null) {
            throw new ARQException("No SPARQL Graph Store service defined for this RDFConnection");
        }
    }

    private void checkDataset() {
        this.checkOpen();
        if (this.destination == null) {
            throw new ARQException("Dataset operations not available - no dataset URL provided");
        }
    }

    private void checkOpen() {
        if (!this.isOpen) {
            throw new ARQException("closed");
        }
    }

    @Override
    public void close() {
        this.isOpen = false;
    }

    @Override
    public boolean isClosed() {
        return !this.isOpen;
    }

    protected HttpEntity graphToHttpEntity(Graph graph) {
        return this.graphToHttpEntity(graph, RDFFormat.NTRIPLES);
    }

    protected HttpEntity graphToHttpEntity(Graph graph, RDFFormat syntax) {
        EntityTemplate entity = new EntityTemplate(out -> RDFDataMgr.write(out, graph, syntax));
        String ct = syntax.getLang().getContentType().getContentType();
        entity.setContentType(ct);
        return entity;
    }

    protected HttpEntity datasetToHttpEntity(DatasetGraph dataset) {
        return this.datasetToHttpEntity(dataset, RDFFormat.NQUADS);
    }

    protected HttpEntity datasetToHttpEntity(DatasetGraph dataset, RDFFormat syntax) {
        EntityTemplate entity = new EntityTemplate(out -> RDFDataMgr.write(out, dataset, syntax));
        String ct = syntax.getLang().getContentType().getContentType();
        entity.setContentType(ct);
        return entity;
    }

    static void exec(Runnable action) {
        try {
            action.run();
        }
        catch (HttpException ex) {
            RDFConnectionRemote.handleHttpException(ex, false);
        }
    }

    static <X> X exec(Supplier<X> action) {
        try {
            return action.get();
        }
        catch (HttpException ex) {
            RDFConnectionRemote.handleHttpException(ex, true);
            return null;
        }
    }

    private static void handleHttpException(HttpException ex, boolean ignore404) {
        if (ex.getResponseCode() == 404 && ignore404) {
            return;
        }
        throw ex;
    }

    @Override
    public void begin(ReadWrite readWrite) {
        this.inner.begin(readWrite);
    }

    @Override
    public void commit() {
        this.inner.commit();
    }

    @Override
    public void abort() {
        this.inner.abort();
    }

    @Override
    public boolean isInTransaction() {
        return this.inner.isInTransaction();
    }

    @Override
    public void end() {
        this.inner.end();
    }

    static class TxnLifecycle
    implements Transactional {
        private ReentrantLock lock = new ReentrantLock();
        private ThreadLocal<ReadWrite> mode = ThreadLocal.withInitial(() -> null);

        TxnLifecycle() {
        }

        @Override
        public void begin(ReadWrite readWrite) {
            if (readWrite == ReadWrite.WRITE) {
                this.lock.lock();
            }
            this.mode.set(readWrite);
        }

        @Override
        public void commit() {
            if (this.mode.get() == ReadWrite.WRITE) {
                this.lock.unlock();
            }
            this.mode.set(null);
        }

        @Override
        public void abort() {
            if (this.mode.get() == ReadWrite.WRITE) {
                this.lock.unlock();
            }
            this.mode.set(null);
        }

        @Override
        public boolean isInTransaction() {
            return this.mode.get() != null;
        }

        @Override
        public void end() {
            ReadWrite rw = this.mode.get();
            if (rw == null) {
                return;
            }
            if (rw == ReadWrite.WRITE) {
                this.abort();
                return;
            }
            this.mode.set(null);
        }
    }
}

