/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.adapters;

import java.io.InputStream;
import java.util.Iterator;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.adapters.AdapterLib;
import org.apache.jena.riot.adapters.AdapterLocationMapper;
import org.apache.jena.riot.adapters.FileManagerModelCache;
import org.apache.jena.riot.system.stream.LocationMapper;
import org.apache.jena.riot.system.stream.Locator;
import org.apache.jena.riot.system.stream.LocatorClassLoader;
import org.apache.jena.riot.system.stream.LocatorFTP;
import org.apache.jena.riot.system.stream.LocatorFile;
import org.apache.jena.riot.system.stream.LocatorHTTP;
import org.apache.jena.riot.system.stream.LocatorZip;
import org.apache.jena.riot.system.stream.StreamManager;
import org.apache.jena.util.FileManager;
import org.apache.jena.util.TypedStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdapterFileManager
extends FileManager {
    private static Logger log = LoggerFactory.getLogger(AdapterFileManager.class);
    private static AdapterFileManager instance = null;
    private final StreamManager streamManager;
    private FileManagerModelCache modelCache = new FileManagerModelCache();

    public static AdapterFileManager get() {
        if (instance == null) {
            instance = AdapterFileManager.makeGlobal();
        }
        return instance;
    }

    public static void setGlobalFileManager(AdapterFileManager globalFileManager) {
        instance = globalFileManager;
    }

    private AdapterFileManager() {
        this.streamManager = new StreamManager();
    }

    @Override
    public FileManager clone() {
        StreamManager sm = this.streamManager.clone();
        AdapterFileManager x = new AdapterFileManager(sm);
        return x;
    }

    public AdapterFileManager(StreamManager streamManager) {
        this(streamManager, streamManager == null ? null : streamManager.getLocationMapper());
    }

    public AdapterFileManager(StreamManager streamManager, LocationMapper mapper) {
        if (streamManager == null) {
            streamManager = new StreamManager();
        }
        this.streamManager = streamManager;
        streamManager.setLocationMapper(mapper);
    }

    public static AdapterFileManager makeGlobal() {
        AdapterFileManager fMgr = new AdapterFileManager(StreamManager.get());
        return fMgr;
    }

    public StreamManager getStreamManager() {
        return this.streamManager;
    }

    @Override
    public void setLocationMapper(org.apache.jena.util.LocationMapper mapper) {
        this.streamManager.setLocationMapper(AdapterLib.copyConvert(mapper));
    }

    @Override
    public org.apache.jena.util.LocationMapper getLocationMapper() {
        return new AdapterLocationMapper(this.streamManager.getLocationMapper());
    }

    @Override
    public Iterator<org.apache.jena.util.Locator> locators() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(org.apache.jena.util.Locator loc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addLocator(org.apache.jena.util.Locator oldloc) {
        Locator loc = AdapterLib.convert(oldloc);
        log.debug("Add location: " + loc.getName());
        this.streamManager.addLocator(loc);
    }

    @Override
    public void addLocatorFile() {
        this.addLocatorFile(null);
    }

    @Override
    public void addLocatorFile(String dir) {
        LocatorFile fLoc = new LocatorFile(dir);
        this.streamManager.addLocator(fLoc);
    }

    @Override
    public void addLocatorClassLoader(ClassLoader cLoad) {
        LocatorClassLoader cLoc = new LocatorClassLoader(cLoad);
        this.streamManager.addLocator(cLoc);
    }

    public void addLocatorHTTP() {
        LocatorHTTP loc = new LocatorHTTP();
        this.streamManager.addLocator(loc);
    }

    public void addLocatorFTP() {
        LocatorFTP loc = new LocatorFTP();
        this.streamManager.addLocator(loc);
    }

    @Override
    public void addLocatorZip(String zfn) {
        LocatorZip loc = new LocatorZip(zfn);
        this.streamManager.addLocator(loc);
    }

    @Override
    public void resetCache() {
        this.modelCache.resetCache();
    }

    @Override
    public void setModelCaching(boolean state) {
        this.modelCache.setModelCaching(state);
    }

    @Override
    public boolean isCachingModels() {
        return this.modelCache.isCachingModels();
    }

    @Override
    public Model getFromCache(String filenameOrURI) {
        return this.modelCache.getFromCache(filenameOrURI);
    }

    @Override
    public boolean hasCachedModel(String filenameOrURI) {
        return this.modelCache.hasCachedModel(filenameOrURI);
    }

    @Override
    public void addCacheModel(String uri, Model m) {
        this.modelCache.addCacheModel(uri, m);
    }

    @Override
    public void removeCacheModel(String uri) {
        this.modelCache.removeCacheModel(uri);
    }

    @Override
    protected Model readModelWorker(Model model, String filenameOrURI, String baseURI, String syntax) {
        Lang lang;
        String mappedURI = this.mapURI(filenameOrURI);
        if (log.isDebugEnabled() && !mappedURI.equals(filenameOrURI)) {
            log.debug("Map: " + filenameOrURI + " => " + mappedURI);
        }
        Lang lang2 = lang = syntax != null ? RDFLanguages.nameToLang(syntax) : RDFLanguages.resourceNameToLang(mappedURI, Lang.RDFXML);
        if (baseURI == null) {
            baseURI = SysRIOT.chooseBaseIRI(filenameOrURI);
        }
        try (TypedInputStream in = this.streamManager.openNoMapOrNull(mappedURI);){
            Lang lang22 = RDFDataMgr.determineLang(mappedURI, in.getContentType(), lang);
            model.read(in, baseURI, lang22.getName());
        }
        return model;
    }

    @Override
    public InputStream open(String filenameOrURI) {
        return this.streamManager.open(filenameOrURI);
    }

    @Override
    public String mapURI(String filenameOrURI) {
        return this.streamManager.mapURI(filenameOrURI);
    }

    @Override
    public InputStream openNoMap(String filenameOrURI) {
        return this.streamManager.openNoMap(filenameOrURI);
    }

    @Override
    public TypedStream openNoMapOrNull(String filenameOrURI) {
        return AdapterLib.convert(this.streamManager.openNoMapOrNull(filenameOrURI));
    }
}

