/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.compiler;

import org.apache.jena.graph.Node;
import org.apache.jena.sdb.compiler.QuadBlock;
import org.apache.jena.sdb.core.SDBRequest;
import org.apache.jena.sdb.core.ScopeEntry;
import org.apache.jena.sdb.core.sqlexpr.S_Equal;
import org.apache.jena.sdb.core.sqlexpr.SqlColumn;
import org.apache.jena.sdb.core.sqlexpr.SqlExprList;
import org.apache.jena.sdb.core.sqlnode.SqlNode;
import org.apache.jena.sdb.core.sqlnode.SqlTable;
import org.apache.jena.sparql.core.Var;

public abstract class SlotCompiler {
    private SDBRequest request;

    public abstract SqlNode start(QuadBlock var1);

    public abstract SqlNode finish(SqlNode var1, QuadBlock var2);

    public SlotCompiler(SDBRequest request) {
        this.request = request;
    }

    protected SDBRequest getRequest() {
        return this.request;
    }

    public final void processSlot(SDBRequest request, SqlTable table, SqlExprList conditions, Node node, String colName) {
        SqlColumn thisCol = new SqlColumn(table, colName);
        if (!node.isVariable()) {
            this.constantSlot(request, node, thisCol, conditions);
            return;
        }
        Var var = Var.alloc(node);
        if (table.getIdScope().hasColumnForVar(var)) {
            ScopeEntry e2 = table.getIdScope().findScopeForVar(var);
            SqlColumn otherCol = e2.getColumn();
            S_Equal c = new S_Equal(otherCol, thisCol);
            conditions.add(c);
            c.addNote("processVar: " + node);
            return;
        }
        table.setIdColumnForVar(var, thisCol);
    }

    protected abstract void constantSlot(SDBRequest var1, Node var2, SqlColumn var3, SqlExprList var4);
}

