/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.compiler;

import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.SetUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.sdb.compiler.OpSQL;
import org.apache.jena.sdb.compiler.QuadBlock;
import org.apache.jena.sdb.compiler.QuadBlockCompiler;
import org.apache.jena.sdb.compiler.SDB_QC;
import org.apache.jena.sdb.compiler.SqlBuilder;
import org.apache.jena.sdb.core.SDBRequest;
import org.apache.jena.sdb.core.ScopeEntry;
import org.apache.jena.sdb.core.sqlexpr.SqlColumn;
import org.apache.jena.sdb.core.sqlnode.SqlNode;
import org.apache.jena.sdb.core.sqlnode.SqlSelectBlock;
import org.apache.jena.sdb.core.sqlnode.SqlTable;
import org.apache.jena.sdb.layout2.TableDescQuads;
import org.apache.jena.sdb.shared.SDBInternalError;
import org.apache.jena.sdb.store.SQLBridge;
import org.apache.jena.sdb.store.SQLBridgeFactory;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpDatasetNames;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.core.Var;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformSDB
extends TransformCopy {
    private static Logger log = LoggerFactory.getLogger(TransformSDB.class);
    private SDBRequest request;
    private QuadBlockCompiler quadBlockCompiler;

    public TransformSDB(SDBRequest request, QuadBlockCompiler quadBlockCompiler) {
        this.request = request;
        this.quadBlockCompiler = quadBlockCompiler;
    }

    @Override
    public Op transform(OpBGP opBGP) {
        return opBGP;
    }

    @Override
    public Op transform(OpQuadPattern quadPattern) {
        QuadBlock qBlk = new QuadBlock(quadPattern);
        SqlNode node = this.quadBlockCompiler.compile(qBlk);
        return new OpSQL(node, quadPattern, this.request);
    }

    @Override
    public Op transform(OpJoin opJoin, Op left, Op right) {
        return super.transform(opJoin, left, right);
    }

    @Override
    public Op transform(OpLeftJoin opJoin, Op left, Op right) {
        Set<Var> rightOptVars;
        if (!this.request.LeftJoinTranslation) {
            return super.transform(opJoin, left, right);
        }
        if (!SDB_QC.isOpSQL(left) || !SDB_QC.isOpSQL(right)) {
            return super.transform(opJoin, left, right);
        }
        if (opJoin.getExprs() != null) {
            return super.transform(opJoin, left, right);
        }
        SqlNode sqlLeft = ((OpSQL)left).getSqlNode();
        SqlNode sqlRight = ((OpSQL)right).getSqlNode();
        Set<ScopeEntry> scopes = sqlLeft.getIdScope().findScopes();
        Set<ScopeEntry> scopes2 = Iter.toSet(Iter.filter(scopes.iterator(), ScopeEntry.OptionalFilter));
        Set<Var> leftOptVars = Iter.toSet(Iter.map(scopes2.iterator(), ScopeEntry::getVar));
        Set<Var> coalesceVars = SetUtils.intersection(leftOptVars, rightOptVars = sqlRight.getIdScope().getVars());
        if (coalesceVars.size() > 0) {
            String alias = this.request.genId("M");
            SqlNode sqlNode = SqlBuilder.leftJoinCoalesce(this.request, alias, sqlLeft, sqlRight, coalesceVars);
            return new OpSQL(sqlNode, opJoin, this.request);
        }
        return new OpSQL(SqlBuilder.leftJoin(this.request, sqlLeft, sqlRight, null), opJoin, this.request);
    }

    @Override
    public Op transform(OpFilter opFilter, Op op) {
        return super.transform(opFilter, op);
    }

    @Override
    public Op transform(OpTable opTable) {
        if (!opTable.isJoinIdentity()) {
            log.error("OpTable : Not join identity");
        }
        return super.transform(opTable);
    }

    @Override
    public Op transform(OpDistinct opDistinct, Op subOp) {
        if (!SDB_QC.isOpSQL(subOp)) {
            return super.transform(opDistinct, subOp);
        }
        if (!this.request.DistinctTranslation) {
            return super.transform(opDistinct, subOp);
        }
        OpSQL opSubSQL = (OpSQL)subOp;
        SqlNode sqlSubOp = opSubSQL.getSqlNode();
        SqlNode n = SqlSelectBlock.distinct(this.request, sqlSubOp);
        OpSQL opSQL = new OpSQL(n, opDistinct, this.request);
        opSQL.setBridge(opSubSQL.getBridge());
        return opSQL;
    }

    @Override
    public Op transform(OpProject opProject, Op subOp) {
        if (!SDB_QC.isOpSQL(subOp)) {
            return super.transform(opProject, subOp);
        }
        List<Var> vars = opProject.getVars();
        return TransformSDB.doBridge(this.request, (OpSQL)subOp, vars, opProject);
    }

    @Override
    public Op transform(OpService opService, Op subOp) {
        return opService;
    }

    private static OpSQL doBridge(SDBRequest request, OpSQL opSQL, List<Var> projectVars, Op original) {
        SqlNode sqlNode = opSQL.getSqlNode();
        SQLBridgeFactory f = request.getStore().getSQLBridgeFactory();
        SQLBridge bridge = f.create(request, sqlNode, projectVars);
        bridge.build();
        sqlNode = bridge.getSqlNode();
        opSQL = new OpSQL(sqlNode, original, request);
        opSQL.setBridge(bridge);
        opSQL.resetSqlNode(sqlNode);
        return opSQL;
    }

    @Override
    public Op transform(OpDatasetNames opDatasetNames) {
        Node g = opDatasetNames.getGraphNode();
        if (!Var.isVar(g)) {
            throw new SDBInternalError("OpDatasetNames - not a variable: " + g);
        }
        Var v = Var.alloc(g);
        TableDescQuads quads = this.request.getStore().getQuadTableDesc();
        SqlTable sqlTableQ = new SqlTable(quads.getTableName());
        sqlTableQ.setIdColumnForVar(v, new SqlColumn(sqlTableQ, quads.getGraphColName()));
        SqlNode sqlNodeQ = SqlSelectBlock.distinct(this.request, sqlTableQ);
        return new OpSQL(sqlNodeQ, opDatasetNames, this.request);
    }
}

