/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.core.sqlnode;

import org.apache.jena.sdb.core.Scope;
import org.apache.jena.sdb.core.ScopeBase;
import org.apache.jena.sdb.core.sqlexpr.SqlColumn;
import org.apache.jena.sdb.core.sqlnode.SqlNode;
import org.apache.jena.sdb.core.sqlnode.SqlNodeBase0;
import org.apache.jena.sdb.core.sqlnode.SqlNodeVisitor;
import org.apache.jena.sdb.core.sqlnode.SqlTransform;
import org.apache.jena.sparql.core.Var;

public class SqlTable
extends SqlNodeBase0 {
    private String tableName;
    protected ScopeBase idScope = null;
    protected ScopeBase nodeScope = null;

    public SqlTable(String name) {
        this(name, name);
    }

    public SqlTable(String aliasName, String tableName) {
        this(aliasName, tableName, new ScopeBase(), new ScopeBase());
    }

    private SqlTable(String aliasName, String tableName, ScopeBase idScope, ScopeBase nodeScope) {
        super(aliasName);
        this.tableName = tableName;
        this.idScope = idScope;
        this.nodeScope = nodeScope;
    }

    @Override
    public boolean isTable() {
        return true;
    }

    @Override
    public SqlTable asTable() {
        return this;
    }

    @Override
    public boolean usesColumn(SqlColumn c) {
        return c.getTable() == this;
    }

    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void visit(SqlNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Scope getIdScope() {
        return this.idScope;
    }

    @Override
    public Scope getNodeScope() {
        return this.nodeScope;
    }

    public void setIdColumnForVar(Var var, SqlColumn thisCol) {
        this.idScope.setColumnForVar(var, thisCol);
    }

    public void setValueColumnForVar(Var var, SqlColumn thisCol) {
        if (this.nodeScope == null) {
            this.nodeScope = new ScopeBase();
        }
        this.nodeScope.setColumnForVar(var, thisCol);
    }

    public int hashCode() {
        int h = 981;
        if (this.tableName != null) {
            h ^= this.tableName.hashCode();
        }
        if (this.getAliasName() != null) {
            h ^= this.getAliasName().hashCode() << 1;
        }
        return h;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SqlTable)) {
            return false;
        }
        SqlTable table = (SqlTable)other;
        if (!this.tableName.equals(table.tableName)) {
            return false;
        }
        if (this.getAliasName() == null && table.getAliasName() == null) {
            return true;
        }
        if (this.getAliasName() == null || table.getAliasName() == null) {
            return false;
        }
        return this.getAliasName().equals(table.getAliasName());
    }

    @Override
    public SqlNode apply(SqlTransform transform) {
        return transform.transform(this);
    }

    @Override
    public SqlNode copy() {
        return new SqlTable(this.tableName, this.getAliasName(), this.idScope, this.nodeScope);
    }
}

