/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.layout2;

import org.apache.jena.sdb.Store;
import org.apache.jena.sdb.StoreDesc;
import org.apache.jena.sdb.compiler.QueryCompilerFactory;
import org.apache.jena.sdb.core.sqlnode.GenerateSQL;
import org.apache.jena.sdb.layout2.TableDescNodes;
import org.apache.jena.sdb.layout2.TableDescQuads;
import org.apache.jena.sdb.layout2.TableDescTriples;
import org.apache.jena.sdb.sql.SDBConnection;
import org.apache.jena.sdb.sql.SDBConnectionHolder;
import org.apache.jena.sdb.sql.TableUtils;
import org.apache.jena.sdb.store.DatabaseType;
import org.apache.jena.sdb.store.LayoutType;
import org.apache.jena.sdb.store.SQLBridgeFactory;
import org.apache.jena.sdb.store.SQLGenerator;
import org.apache.jena.sdb.store.StoreConfig;
import org.apache.jena.sdb.store.StoreFormatter;
import org.apache.jena.sdb.store.StoreLoader;

public abstract class StoreBase
extends SDBConnectionHolder
implements Store {
    protected StoreDesc storeDescription;
    protected StoreFormatter formatter;
    protected StoreLoader loader;
    protected QueryCompilerFactory compilerF;
    protected SQLBridgeFactory sqlBridgeF;
    protected SQLGenerator sqlGenerator;
    protected StoreConfig configuration;
    protected TableDescTriples tripleTableDesc;
    protected TableDescQuads quadTableDesc = null;
    protected TableDescNodes nodeTableDesc;
    protected boolean isClosed = false;

    public StoreBase(SDBConnection connection, StoreDesc desc, StoreFormatter formatter, StoreLoader loader, QueryCompilerFactory compilerF, SQLBridgeFactory sqlBridgeF, SQLGenerator sqlGenerator, TableDescTriples tripleTableDesc, TableDescQuads quadTableDesc, TableDescNodes nodeTableDesc) {
        super(connection);
        this.storeDescription = desc;
        this.formatter = formatter;
        this.loader = loader;
        this.compilerF = compilerF;
        this.sqlBridgeF = sqlBridgeF;
        if (sqlGenerator == null) {
            sqlGenerator = new GenerateSQL();
        }
        this.sqlGenerator = sqlGenerator;
        this.tripleTableDesc = tripleTableDesc;
        this.quadTableDesc = quadTableDesc;
        this.nodeTableDesc = nodeTableDesc;
        this.configuration = new StoreConfig(this.connection());
    }

    @Override
    public SDBConnection getConnection() {
        return this.connection();
    }

    @Override
    public QueryCompilerFactory getQueryCompilerFactory() {
        return this.compilerF;
    }

    @Override
    public SQLBridgeFactory getSQLBridgeFactory() {
        return this.sqlBridgeF;
    }

    @Override
    public SQLGenerator getSQLGenerator() {
        return this.sqlGenerator;
    }

    @Override
    public StoreFormatter getTableFormatter() {
        return this.formatter;
    }

    @Override
    public StoreLoader getLoader() {
        return this.loader;
    }

    @Override
    public StoreConfig getConfiguration() {
        return this.configuration;
    }

    @Override
    public DatabaseType getDatabaseType() {
        return this.storeDescription.getDbType();
    }

    @Override
    public LayoutType getLayoutType() {
        return this.storeDescription.getLayout();
    }

    @Override
    public void close() {
        this.getLoader().close();
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public long getSize() {
        return TableUtils.getTableSize(this.getConnection().getSqlConnection(), "Triples");
    }

    @Override
    public TableDescNodes getNodeTableDesc() {
        return this.nodeTableDesc;
    }

    @Override
    public TableDescTriples getTripleTableDesc() {
        return this.tripleTableDesc;
    }

    @Override
    public TableDescQuads getQuadTableDesc() {
        return this.quadTableDesc;
    }
}

