/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.layout2;

import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.sdb.SDBException;
import org.apache.jena.sparql.util.Named;
import org.apache.jena.sparql.util.NodeUtils;

public enum ValueType implements Named
{
    BNODE{

        @Override
        public XSDDatatype getDatatype() {
            return null;
        }

        @Override
        public int getTypeId() {
            return 1;
        }

        @Override
        public String getName() {
            return "BNode";
        }
    }
    ,
    URI{

        @Override
        public XSDDatatype getDatatype() {
            return null;
        }

        @Override
        public int getTypeId() {
            return 2;
        }

        @Override
        public String getName() {
            return "URI";
        }
    }
    ,
    STRING{

        @Override
        public XSDDatatype getDatatype() {
            return null;
        }

        @Override
        public int getTypeId() {
            return 3;
        }

        @Override
        public String getName() {
            return "String";
        }
    }
    ,
    XSDSTRING{

        @Override
        public XSDDatatype getDatatype() {
            return XSDDatatype.XSDstring;
        }

        @Override
        public int getTypeId() {
            return 4;
        }

        @Override
        public String getName() {
            return "XSD String";
        }
    }
    ,
    INTEGER{

        @Override
        public XSDDatatype getDatatype() {
            return XSDDatatype.XSDinteger;
        }

        @Override
        public int getTypeId() {
            return 5;
        }

        @Override
        public String getName() {
            return "Integer";
        }
    }
    ,
    DOUBLE{

        @Override
        public XSDDatatype getDatatype() {
            return XSDDatatype.XSDdouble;
        }

        @Override
        public int getTypeId() {
            return 6;
        }

        @Override
        public String getName() {
            return "Double";
        }
    }
    ,
    DATETIME{

        @Override
        public XSDDatatype getDatatype() {
            return XSDDatatype.XSDdateTime;
        }

        @Override
        public int getTypeId() {
            return 7;
        }

        @Override
        public String getName() {
            return "Datetime";
        }
    }
    ,
    VAR{

        @Override
        public XSDDatatype getDatatype() {
            return null;
        }

        @Override
        public int getTypeId() {
            return 8;
        }

        @Override
        public String getName() {
            return "var";
        }
    }
    ,
    OTHER{

        @Override
        public XSDDatatype getDatatype() {
            return null;
        }

        @Override
        public int getTypeId() {
            return 50;
        }

        @Override
        public String getName() {
            return "Other";
        }
    };


    public abstract int getTypeId();

    public abstract XSDDatatype getDatatype();

    @Override
    public abstract String getName();

    public String toString() {
        return this.getName();
    }

    public static ValueType lookup(Node n) {
        if (n.isURI()) {
            return URI;
        }
        if (n.isBlank()) {
            return BNODE;
        }
        if (n.isLiteral()) {
            if (NodeUtils.isSimpleString(n)) {
                return STRING;
            }
            if (NodeUtils.isLangString(n)) {
                return STRING;
            }
            if (n.getLiteralDatatypeURI() == null) {
                return STRING;
            }
            if (n.getLiteralDatatype() == XSDDatatype.XSDstring) {
                return XSDSTRING;
            }
            if (n.getLiteralDatatype() == XSDDatatype.XSDinteger) {
                return INTEGER;
            }
            if (n.getLiteralDatatype() == XSDDatatype.XSDdouble) {
                return DOUBLE;
            }
            if (n.getLiteralDatatype() == XSDDatatype.XSDdateTime) {
                return DATETIME;
            }
        }
        return OTHER;
    }

    public static ValueType lookup(int type) {
        if (type == BNODE.getTypeId()) {
            return BNODE;
        }
        if (type == URI.getTypeId()) {
            return URI;
        }
        if (type == STRING.getTypeId()) {
            return STRING;
        }
        if (type == XSDSTRING.getTypeId()) {
            return XSDSTRING;
        }
        if (type == INTEGER.getTypeId()) {
            return INTEGER;
        }
        if (type == DOUBLE.getTypeId()) {
            return DOUBLE;
        }
        if (type == DATETIME.getTypeId()) {
            return DATETIME;
        }
        if (type == VAR.getTypeId()) {
            return VAR;
        }
        if (type == OTHER.getTypeId()) {
            return OTHER;
        }
        throw new SDBException("Unknown type (" + type + ")");
    }
}

