/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.layout2.hash;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.sdb.Store;
import org.apache.jena.sdb.core.sqlexpr.SqlConstant;
import org.apache.jena.sdb.layout2.NodeLayout2;
import org.apache.jena.sdb.layout2.TableDescNodes;
import org.apache.jena.sdb.sql.RS;
import org.apache.jena.sdb.sql.ResultSetJDBC;
import org.apache.jena.sdb.sql.SDBConnection;
import org.apache.jena.sdb.sql.SQLUtils;
import org.apache.jena.sdb.store.TableDesc;
import org.apache.jena.sdb.store.TupleLoaderOne;
import org.apache.jena.sparql.util.NodeUtils;

public class TupleLoaderOneHash
extends TupleLoaderOne {
    public TupleLoaderOneHash(SDBConnection connection) {
        super(connection);
    }

    public TupleLoaderOneHash(SDBConnection connection, TableDesc tableDesc) {
        super(connection, tableDesc);
    }

    public TupleLoaderOneHash(Store store, TableDesc tableDesc) {
        super(store.getConnection(), tableDesc);
    }

    @Override
    public SqlConstant getRefForNode(Node node) {
        return new SqlConstant(NodeLayout2.hash(node));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqlConstant insertNode(Node node) throws SQLException {
        ResultSetJDBC rsx;
        long hash;
        String datatype;
        String lang;
        String lex;
        int typeId;
        block4: {
            SqlConstant sqlConstant;
            typeId = NodeLayout2.nodeToType(node);
            lex = NodeLayout2.nodeToLex(node);
            lang = "";
            datatype = "";
            if (node.isLiteral()) {
                lang = node.getLiteralLanguage();
                datatype = node.getLiteralDatatypeURI();
                if (NodeUtils.isSimpleString(node) || NodeUtils.isLangString(node)) {
                    datatype = "";
                }
            }
            hash = NodeLayout2.hash(lex, lang, datatype, typeId);
            String sqlStmtTest = StrUtils.strjoinNL("SELECT hash FROM " + TableDescNodes.name(), "WHERE hash = " + hash);
            rsx = null;
            try {
                rsx = this.connection().execQuery(sqlStmtTest);
                ResultSet rs = rsx.get();
                boolean b = rs.next();
                if (!b) break block4;
                sqlConstant = new SqlConstant(hash);
            }
            catch (Throwable throwable) {
                RS.close(rsx);
                throw throwable;
            }
            RS.close(rsx);
            return sqlConstant;
        }
        RS.close(rsx);
        String sqlStmt = StrUtils.strjoinNL("INSERT INTO " + TableDescNodes.name() + "(hash,lex,lang,datatype,type) VALUES", "  (" + hash + ", ", "   " + SQLUtils.quoteStr(lex) + ", ", "   " + SQLUtils.quoteStr(lang) + ", ", "   " + SQLUtils.quoteStr(datatype) + ", ", "   " + typeId, ")");
        this.connection().execUpdate(sqlStmt);
        return new SqlConstant(hash);
    }
}

