/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.store;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.sdb.sql.SDBConnection;
import org.apache.jena.sdb.sql.SDBConnectionHolder;
import org.apache.jena.sdb.sql.TableUtils;
import org.apache.jena.sdb.store.ConfigVocab;
import org.apache.jena.sdb.store.TaggedString;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreConfig
extends SDBConnectionHolder {
    private static Logger log = LoggerFactory.getLogger(StoreConfig.class);
    private static final String serializationFormat = "N-TRIPLE";
    public static final String defaultTag = "config";
    private boolean initialized = false;
    private Map<String, Model> cache = new HashMap<String, Model>();
    private boolean caching = true;
    TaggedString storage = null;
    private Resource rootType = ResourceFactory.createResource();

    public StoreConfig(SDBConnection sdb) {
        super(sdb);
        this.storage = new TaggedString(this.connection());
    }

    public List<String> tables() {
        return TableUtils.getTableNames(this.connection().getSqlConnection());
    }

    private Resource getRoot() {
        Model model = this.getModel();
        return GraphUtils.getResourceByType(model, ConfigVocab.typeConfig);
    }

    public void removeModel() {
        this.removeModel(defaultTag);
    }

    public void removeModel(String tag) {
        this.init();
        log.trace(".removeModel: " + tag);
        this.storage.remove(tag);
    }

    public Model getModel() {
        return this.getModel(defaultTag);
    }

    public Model getModel(String tag) {
        this.init();
        log.trace(".getModel: " + tag);
        Model m = null;
        if (this.caching && this.cache.containsKey(tag)) {
            log.trace(".getModel: cache hit for " + tag);
            return this.cache.get(tag);
        }
        log.trace(".getModel: cache miss for " + tag);
        m = this.readModel(tag);
        if (m == null) {
            return null;
        }
        if (this.caching) {
            this.cache.put(tag, m);
        }
        return m;
    }

    public void setModel(Model m) {
        this.setModel(defaultTag, m);
    }

    public void setModel(String tag, Model m) {
        this.init();
        log.trace(".setModel: " + tag);
        this.writeModel(tag, m);
        if (this.caching) {
            log.trace(".setModel: cache model for " + tag);
            this.cache.put(tag, m);
        }
    }

    public List<String> getTags() {
        this.init();
        return this.storage.tags();
    }

    public void reset() {
        this.storage.reset();
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.storage != null) {
            return;
        }
    }

    private Model readModel(String tag) {
        log.trace(".readModel: " + tag);
        String s = this.storage.get(tag);
        if (s == null) {
            return null;
        }
        Model m = ModelFactory.createDefaultModel();
        StringReader r = new StringReader(s);
        m.read(r, null, serializationFormat);
        return m;
    }

    private void writeModel(String tag, Model model) {
        log.trace(".writeModel: " + tag);
        StringWriter x = new StringWriter();
        model.write(x, serializationFormat);
        this.storage.set(tag, x.toString());
    }
}

