/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.util;

import java.sql.SQLException;
import org.apache.jena.sdb.Store;
import org.apache.jena.sdb.sql.SDBConnection;
import org.apache.jena.sdb.sql.SDBExceptionSQL;

public class HSQLUtils {
    public static void shutdown(Store store) {
        HSQLUtils.shutdown(store.getConnection());
    }

    public static void shutdown(SDBConnection sdb) {
        try {
            if (sdb.hasSQLConnection()) {
                sdb.exec("SHUTDOWN COMPACT;");
            }
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL(ex);
        }
    }

    public static void checkpoint(Store store) {
        HSQLUtils.checkpoint(store.getConnection());
    }

    public static void checkpoint(SDBConnection sdb) {
        try {
            if (sdb.hasSQLConnection()) {
                sdb.exec("CHECKPOINT DEFRAG;");
            }
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL(ex);
        }
    }
}

