/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.resultset.ResultSetMem;

public class ResultSetUtils {
    public static List<RDFNode> resultSetToList(ResultSet rs, String selectElement) {
        ArrayList<RDFNode> items = new ArrayList<RDFNode>();
        while (rs.hasNext()) {
            QuerySolution qs = rs.nextSolution();
            RDFNode n = qs.get(selectElement);
            items.add(n);
        }
        return items;
    }

    public static List<String> resultSetToStringList(ResultSet rs, String selectElement, String literalOrResource) {
        ArrayList<String> items = new ArrayList<String>();
        while (rs.hasNext()) {
            QuerySolution qs = rs.nextSolution();
            RDFNode rn = qs.get(selectElement);
            if (rn.isLiteral()) {
                items.add(((Literal)rn).getLexicalForm());
                continue;
            }
            if (rn.isURIResource()) {
                items.add(((Resource)rn).getURI());
                continue;
            }
            if (rn.isAnon()) {
                items.add(((Resource)rn).getId().getLabelString());
                continue;
            }
            throw new ARQException("Unknow thing in results : " + rn);
        }
        return items;
    }

    public static ResultSet union(ResultSet ... sets) {
        return new ResultSetMem(sets);
    }
}

