/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.base.objectfile;

import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorSlotted;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.tdb.base.block.Block;
import org.apache.jena.tdb.base.file.BufferChannel;
import org.apache.jena.tdb.base.file.FileException;
import org.apache.jena.tdb.base.objectfile.ObjectFile;
import org.apache.jena.tdb.sys.SystemTDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectFileStorage
implements ObjectFile {
    private static Logger log = LoggerFactory.getLogger(ObjectFileStorage.class);
    public static boolean logging = false;
    private ByteBuffer lengthBuffer = ByteBuffer.allocate(4);
    private final ByteBuffer writeBuffer;
    private final BufferChannel file;
    private long filesize;
    private boolean inAllocWrite = false;
    private Block allocBlock = null;
    private long allocLocation = -1L;
    int oldBufferPosn = -1;
    int oldBufferLimit = -1;

    private void log(String fmt, Object ... args) {
        if (!logging) {
            return;
        }
        log.debug(this.state() + " " + String.format(fmt, args));
    }

    public ObjectFileStorage(BufferChannel file) {
        this(file, 8192);
    }

    public ObjectFileStorage(BufferChannel file, int bufferSize) {
        this.file = file;
        this.filesize = file.size();
        this.file.position(this.filesize);
        this.log("File size: 0x%X, posn: 0x%X", this.filesize, file.position());
        this.writeBuffer = bufferSize >= 0 ? ByteBuffer.allocate(bufferSize) : null;
    }

    @Override
    public long write(ByteBuffer bb) {
        this.log("W", new Object[0]);
        if (this.inAllocWrite) {
            Log.error(this, "In the middle of an alloc-write");
        }
        this.inAllocWrite = false;
        if (this.writeBuffer == null) {
            long x = this.rawWrite(bb);
            this.log("W -> 0x%X", x);
            return x;
        }
        int len = bb.limit() - bb.position();
        int spaceNeeded = len + 4;
        if (this.writeBuffer.position() + spaceNeeded > this.writeBuffer.capacity()) {
            this.flushOutputBuffer();
        }
        if (this.writeBuffer.position() + spaceNeeded > this.writeBuffer.capacity()) {
            long x = this.rawWrite(bb);
            if (logging) {
                this.log("W -> 0x%X", x);
            }
            return x;
        }
        long loc = (long)this.writeBuffer.position() + this.filesize;
        this.writeBuffer.putInt(len);
        this.writeBuffer.put(bb);
        if (logging) {
            this.log("W -> 0x%X", loc);
        }
        return loc;
    }

    private long rawWrite(ByteBuffer bb) {
        if (logging) {
            this.log("RW %s", bb);
        }
        int len = bb.limit() - bb.position();
        this.lengthBuffer.rewind();
        this.lengthBuffer.putInt(len);
        this.lengthBuffer.flip();
        long location = this.file.position();
        this.file.write(this.lengthBuffer);
        int x = this.file.write(bb);
        if (x != len) {
            throw new FileException();
        }
        this.filesize = this.filesize + (long)x + 4L;
        if (logging) {
            this.log("Posn: %d", this.file.position());
            this.log("RW ->0x%X", location);
        }
        return location;
    }

    @Override
    public Block allocWrite(int bytesSpace) {
        int start;
        if (this.inAllocWrite) {
            Log.error(this, "In the middle of an alloc-write");
        }
        int spaceRequired = bytesSpace + 4;
        if (this.writeBuffer != null && spaceRequired > this.writeBuffer.remaining()) {
            this.flushOutputBuffer();
        }
        if (this.writeBuffer == null || spaceRequired > this.writeBuffer.remaining()) {
            this.inAllocWrite = true;
            ByteBuffer bb = ByteBuffer.allocate(bytesSpace);
            this.allocBlock = new Block(this.filesize, bb);
            this.allocLocation = -1L;
            return this.allocBlock;
        }
        this.inAllocWrite = true;
        this.oldBufferPosn = start = this.writeBuffer.position();
        this.oldBufferLimit = this.writeBuffer.limit();
        this.allocLocation = this.filesize + (long)start;
        this.writeBuffer.putInt(bytesSpace);
        this.writeBuffer.position(start + 4);
        this.writeBuffer.limit(start + spaceRequired);
        ByteBuffer bb = this.writeBuffer.slice();
        this.allocBlock = new Block(this.allocLocation, bb);
        if (logging) {
            this.log("AW: %s->0x%X", this.state(), this.allocLocation);
        }
        return this.allocBlock;
    }

    @Override
    public void completeWrite(Block block) {
        if (logging) {
            this.log("CW: %s @0x%X", block, this.allocLocation);
        }
        if (!this.inAllocWrite) {
            throw new FileException("Not in the process of an allocated write operation pair");
        }
        if (this.allocBlock != null && this.allocBlock.getByteBuffer() != block.getByteBuffer()) {
            throw new FileException("Wrong byte buffer in an allocated write operation pair");
        }
        this.inAllocWrite = false;
        ByteBuffer buffer = block.getByteBuffer();
        if (this.allocLocation == -1L) {
            this.rawWrite(buffer);
            return;
        }
        if (0 != buffer.position()) {
            log.warn("ObjectFleStorage: position != 0");
        }
        buffer.position(0);
        int actualLength = buffer.limit() - buffer.position();
        int idx = (int)(this.allocLocation - this.filesize);
        this.writeBuffer.putInt(idx, actualLength);
        this.allocBlock = null;
        int newLen = idx + actualLength + 4;
        this.writeBuffer.position(newLen);
        this.writeBuffer.limit(this.writeBuffer.capacity());
        this.allocLocation = -1L;
        this.oldBufferPosn = -1;
        this.oldBufferLimit = -1;
    }

    @Override
    public void abortWrite(Block block) {
        this.allocBlock = null;
        int oldstart = (int)(this.allocLocation - this.filesize);
        if (oldstart != this.oldBufferPosn) {
            throw new FileException("Wrong reset point: calc=" + oldstart + " : expected=" + this.oldBufferPosn);
        }
        this.writeBuffer.position(oldstart);
        this.writeBuffer.limit(this.oldBufferLimit);
        this.allocLocation = -1L;
        this.oldBufferPosn = -1;
        this.oldBufferLimit = -1;
        this.inAllocWrite = false;
    }

    private void flushOutputBuffer() {
        if (logging) {
            this.log("Flush", new Object[0]);
        }
        if (this.writeBuffer == null) {
            return;
        }
        if (this.writeBuffer.position() == 0) {
            return;
        }
        long location = this.filesize;
        this.writeBuffer.flip();
        int x = this.file.write(this.writeBuffer);
        this.filesize += (long)x;
        this.writeBuffer.clear();
    }

    @Override
    public void reposition(long posn) {
        if (this.inAllocWrite) {
            throw new FileException("In the middle of an alloc-write");
        }
        if (posn < 0L || posn > this.length()) {
            throw new IllegalArgumentException("reposition: Bad location: " + posn);
        }
        this.flushOutputBuffer();
        this.file.truncate(posn);
        this.filesize = posn;
    }

    @Override
    public void truncate(long size) {
        this.reposition(size);
    }

    @Override
    public ByteBuffer read(long loc) {
        if (logging) {
            this.log("R(0x%X)", loc);
        }
        if (this.inAllocWrite) {
            throw new FileException("In the middle of an alloc-write");
        }
        if (loc < 0L) {
            throw new IllegalArgumentException("ObjectFile.read[" + this.file.getLabel() + "]: Bad read: " + loc);
        }
        if (loc >= this.filesize) {
            if (loc >= this.filesize + (long)this.writeBuffer.position()) {
                throw new IllegalArgumentException("ObjectFileStorage.read[" + this.file.getLabel() + "]: Bad read: location=" + loc + " >= max=" + (this.filesize + (long)this.writeBuffer.position()));
            }
            int x = this.writeBuffer.position();
            int y = this.writeBuffer.limit();
            int offset = (int)(loc - this.filesize);
            int len = this.writeBuffer.getInt(offset);
            int posn = offset + 4;
            this.writeBuffer.position(posn);
            this.writeBuffer.limit(posn + len);
            ByteBuffer bb = this.writeBuffer.slice();
            this.writeBuffer.limit(y);
            this.writeBuffer.position(x);
            return bb;
        }
        this.lengthBuffer.clear();
        int x = this.file.read(this.lengthBuffer, loc);
        if (x != 4) {
            throw new FileException("ObjectFileStorage.read[" + this.file.getLabel() + "](" + loc + ")[filesize=" + this.filesize + "][file.size()=" + this.file.size() + "]: Failed to read the length : got " + x + " bytes");
        }
        int len = this.lengthBuffer.getInt(0);
        if ((long)len > this.filesize - (loc + 4L)) {
            String msg = "ObjectFileStorage.read[" + this.file.getLabel() + "](" + loc + ")[filesize=" + this.filesize + "][file.size()=" + this.file.size() + "]: Impossibly large object : " + len + " bytes > filesize-(loc+SizeOfInt)=" + (this.filesize - (loc + 4L));
            SystemTDB.errlog.error(msg);
            throw new FileException(msg);
        }
        ByteBuffer bb = ByteBuffer.allocate(len);
        if (len == 0) {
            return bb;
        }
        x = this.file.read(bb, loc + 4L);
        bb.flip();
        if (x != len) {
            throw new FileException("ObjectFileStorage.read: Failed to read the object (" + len + " bytes) : got " + x + " bytes");
        }
        return bb;
    }

    @Override
    public long length() {
        if (this.writeBuffer == null) {
            return this.filesize;
        }
        return this.filesize + (long)this.writeBuffer.position();
    }

    @Override
    public boolean isEmpty() {
        if (this.writeBuffer == null) {
            return this.filesize == 0L;
        }
        return this.writeBuffer.position() == 0 && this.filesize == 0L;
    }

    @Override
    public void close() {
        this.flushOutputBuffer();
        this.file.close();
    }

    @Override
    public void sync() {
        this.flushOutputBuffer();
        this.file.sync();
    }

    @Override
    public String getLabel() {
        return this.file.getLabel();
    }

    public String toString() {
        return this.file.getLabel();
    }

    @Override
    public Iterator<Pair<Long, ByteBuffer>> all() {
        this.flushOutputBuffer();
        ObjectIterator iter = new ObjectIterator(0L, this.filesize);
        if (this.writeBuffer == null || this.writeBuffer.position() == 0) {
            return iter;
        }
        return Iter.concat(iter, new BufferIterator(this.writeBuffer));
    }

    private String state() {
        if (this.writeBuffer == null) {
            return String.format(this.getLabel() + ": filesize=0x%X, file=(0x%X, 0x%X)", this.filesize, this.file.position(), this.file.size());
        }
        return String.format(this.getLabel() + ": filesize=0x%X, file=(0x%X, 0x%X), writeBuffer=(0x%X,0x%X)", this.filesize, this.file.position(), this.file.size(), this.writeBuffer.position(), this.writeBuffer.limit());
    }

    private class ObjectIterator
    implements Iterator<Pair<Long, ByteBuffer>> {
        private final long start;
        private final long finish;
        private long current;

        public ObjectIterator(long start, long finish) {
            this.start = start;
            this.finish = finish;
            this.current = start;
        }

        @Override
        public boolean hasNext() {
            return this.current < this.finish;
        }

        @Override
        public Pair<Long, ByteBuffer> next() {
            long x = this.current;
            long filePosn = ObjectFileStorage.this.file.position();
            ByteBuffer bb = ObjectFileStorage.this.read(this.current);
            ObjectFileStorage.this.file.position(filePosn);
            this.current = this.current + (long)bb.limit() + 4L;
            return new Pair<Long, ByteBuffer>(x, bb);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class BufferIterator
    extends IteratorSlotted<Pair<Long, ByteBuffer>>
    implements Iterator<Pair<Long, ByteBuffer>> {
        private ByteBuffer buffer;
        private int posn;

        public BufferIterator(ByteBuffer buffer) {
            this.buffer = buffer;
            this.posn = 0;
        }

        @Override
        protected Pair<Long, ByteBuffer> moveToNext() {
            if (this.posn >= this.buffer.limit()) {
                return null;
            }
            int x = this.buffer.getInt(this.posn);
            this.posn += 4;
            ByteBuffer bb = ByteBuffer.allocate(x);
            int p = this.buffer.position();
            this.buffer.position(this.posn);
            this.buffer.get(bb.array());
            this.buffer.position(p);
            this.posn += x;
            return new Pair<Long, ByteBuffer>(Long.valueOf(x), bb);
        }

        @Override
        protected boolean hasMore() {
            return this.posn < this.buffer.limit();
        }
    }
}

