/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.base.page;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.tdb.base.block.Block;
import org.apache.jena.tdb.base.block.BlockConverter;
import org.apache.jena.tdb.base.block.BlockMgr;
import org.apache.jena.tdb.base.block.BlockType;
import org.apache.jena.tdb.base.page.Page;

public class PageBlockMgr<T extends Page> {
    protected final BlockMgr blockMgr;
    protected BlockConverter<T> pageFactory;

    protected PageBlockMgr(BlockConverter<T> pageFactory, BlockMgr blockMgr) {
        this.pageFactory = pageFactory;
        this.blockMgr = blockMgr;
    }

    protected void setConverter(BlockConverter<T> pageFactory) {
        this.pageFactory = pageFactory;
    }

    public BlockMgr getBlockMgr() {
        return this.blockMgr;
    }

    public T create(BlockType bType) {
        Block block = this.blockMgr.allocate(-1);
        block.setModified(true);
        T page = this.pageFactory.createFromBlock(block, bType);
        return page;
    }

    public T getWrite(int id) {
        Block block = this.blockMgr.getWrite(id);
        block.setModified(true);
        T page = this.pageFactory.fromBlock(block);
        return page;
    }

    public T getRead(int id) {
        Block block = this.blockMgr.getRead(id);
        T page = this.pageFactory.fromBlock(block);
        return page;
    }

    public void put(T page) {
        this.write(page);
        this.release((Page)page);
    }

    public void write(T page) {
        Block blk = this.pageFactory.toBlock(page);
        this.blockMgr.write(blk);
    }

    public void release(Page page) {
        Block block = page.getBackingBlock();
        this.blockMgr.release(block);
    }

    private void warn(String string) {
        Log.warn(this, string);
    }

    public void free(Page page) {
        Block block = page.getBackingBlock();
        this.blockMgr.free(block);
    }

    public void promote(Page page) {
        Block block = page.getBackingBlock();
        Block block2 = this.blockMgr.promote(block);
        if (block2 != block) {
            block2.setModified(true);
            page.reset(block2);
        }
    }

    public boolean valid(int id) {
        return this.blockMgr.valid(id);
    }

    public void dump() {
        int idx = 0;
        while (this.valid(idx)) {
            T page = this.getRead(idx);
            System.out.println(page);
            this.release((Page)page);
            ++idx;
        }
    }

    public void startUpdate() {
        this.blockMgr.beginUpdate();
    }

    public void finishUpdate() {
        this.blockMgr.endUpdate();
    }

    public void startRead() {
        this.blockMgr.beginRead();
    }

    public void finishRead() {
        this.blockMgr.endRead();
    }
}

