/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.index;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.tdb.base.record.Record;
import org.apache.jena.tdb.base.record.RecordFactory;
import org.apache.jena.tdb.index.Index;

public class IndexMap
implements Index {
    private final Map<ByteArray, ByteArray> index = new HashMap<ByteArray, ByteArray>();
    private final RecordFactory recordFactory;

    public IndexMap(RecordFactory recordFactory) {
        this.recordFactory = recordFactory;
    }

    @Override
    public Record find(Record record) {
        ByteArray k = IndexMap.wrap(record.getKey());
        ByteArray v = this.index.get(k);
        if (v == null) {
            return null;
        }
        return this.record(k, v);
    }

    @Override
    public boolean contains(Record record) {
        Record r = this.find(record);
        if (r == null) {
            return false;
        }
        if (!this.recordFactory.hasValue()) {
            return true;
        }
        return Bytes.compare(record.getValue(), r.getValue()) == 0;
    }

    @Override
    public boolean add(Record record) {
        Record r = this.find(record);
        if (r != null && r.equals(record)) {
            return false;
        }
        this.index.put(IndexMap.wrap(record.getKey()), IndexMap.wrap(record.getValue()));
        return true;
    }

    @Override
    public boolean delete(Record record) {
        ByteArray x = this.index.remove(IndexMap.wrap(record.getKey()));
        return x != null;
    }

    @Override
    public Iterator<Record> iterator() {
        return new Iterator<Record>(){
            Iterator<Map.Entry<ByteArray, ByteArray>> iter;
            {
                this.iter = IndexMap.this.index.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Record next() {
                Map.Entry<ByteArray, ByteArray> e2 = this.iter.next();
                return IndexMap.this.record(e2.getKey(), e2.getValue());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public RecordFactory getRecordFactory() {
        return this.recordFactory;
    }

    @Override
    public boolean isEmpty() {
        return this.index.isEmpty();
    }

    @Override
    public void clear() {
        this.index.clear();
    }

    @Override
    public void check() {
    }

    @Override
    public long size() {
        return this.index.size();
    }

    @Override
    public void sync() {
    }

    @Override
    public void close() {
    }

    private static ByteArray wrap(byte[] b) {
        return new ByteArray(b);
    }

    private Record record(ByteArray k, ByteArray v) {
        return this.recordFactory.create(k.bytes, v.bytes);
    }

    private static class ByteArray {
        byte[] bytes;

        ByteArray(byte[] bytes) {
            this.bytes = bytes;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.bytes);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ByteArray other = (ByteArray)obj;
            return Arrays.equals(this.bytes, other.bytes);
        }
    }
}

