/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.varia;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.varia.ExternallyRolledFileAppender;

class HUPNode
implements Runnable {
    Socket socket;
    DataInputStream dis;
    DataOutputStream dos;
    ExternallyRolledFileAppender er;

    public HUPNode(Socket socket, ExternallyRolledFileAppender er) {
        this.socket = socket;
        this.er = er;
        try {
            this.dis = new DataInputStream(socket.getInputStream());
            this.dos = new DataOutputStream(socket.getOutputStream());
        }
        catch (InterruptedIOException e2) {
            Thread.currentThread().interrupt();
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        catch (RuntimeException e4) {
            e4.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            String line = this.dis.readUTF();
            LogLog.debug("Got external roll over signal.");
            if ("RollOver".equals(line)) {
                ExternallyRolledFileAppender externallyRolledFileAppender = this.er;
                synchronized (externallyRolledFileAppender) {
                    this.er.rollOver();
                }
                this.dos.writeUTF("OK");
            } else {
                this.dos.writeUTF("Expecting [RollOver] string.");
            }
            this.dos.close();
        }
        catch (InterruptedIOException e2) {
            Thread.currentThread().interrupt();
            LogLog.error("Unexpected exception. Exiting HUPNode.", e2);
        }
        catch (IOException e3) {
            LogLog.error("Unexpected exception. Exiting HUPNode.", e3);
        }
        catch (RuntimeException e4) {
            LogLog.error("Unexpected exception. Exiting HUPNode.", e4);
        }
    }
}

