/*
 * Decompiled with CFR 0.152.
 */
package sdb;

import arq.cmdline.ModQueryIn;
import java.util.List;
import jena.cmd.ArgDecl;
import jena.cmd.CmdException;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.Query;
import org.apache.jena.query.Syntax;
import org.apache.jena.sdb.SDB;
import org.apache.jena.sdb.Store;
import org.apache.jena.sdb.StoreDesc;
import org.apache.jena.sdb.engine.QueryEngineSDB;
import org.apache.jena.sdb.store.LayoutType;
import org.apache.jena.sdb.util.PrintSDB;
import org.apache.jena.sparql.algebra.Op;
import sdb.cmd.CmdArgsDB;

public class sdbprint
extends CmdArgsDB {
    LayoutType layoutDefault = LayoutType.LayoutTripleNodesHash;
    static final String divider = "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -";
    ModQueryIn modQuery = new ModQueryIn(Syntax.syntaxARQ);
    ArgDecl argDeclPrintSQL = new ArgDecl(false, "sql");
    ArgDecl argDeclPrint = new ArgDecl(true, "print");
    boolean printQuery = false;
    boolean printOp = false;
    boolean printSqlNode = false;
    boolean printPlan = false;
    boolean printSQL = false;
    boolean needDivider = false;

    public static void main(String ... argv) {
        SDB.init();
        new sdbprint(argv).mainRun();
    }

    public sdbprint(String ... args) {
        super(args);
        super.addModule(this.modQuery);
        super.getUsage().startCategory("SQL");
        super.add(this.argDeclPrintSQL, "--sql", "Print SQL");
        super.add(this.argDeclPrint, "--print=", "Print any of 'query', 'op', 'sqlnode', 'SQL', 'plan'");
    }

    @Override
    protected void processModulesAndArgs() {
        StoreDesc storeDesc = this.getModStore().getStoreDesc();
        storeDesc.connDesc.setJdbcURL("jdbc:none");
        if (storeDesc.getLayout() == null) {
            storeDesc.setLayout(this.layoutDefault);
        }
        this.printSQL = this.contains(this.argDeclPrintSQL);
        List<String> strList = this.getValues(this.argDeclPrint);
        for (String arg : strList) {
            if (arg.equalsIgnoreCase("query")) {
                this.printQuery = true;
                continue;
            }
            if (arg.equalsIgnoreCase("Op")) {
                this.printOp = true;
                continue;
            }
            if (arg.equalsIgnoreCase("SqlNode")) {
                this.printSqlNode = true;
                continue;
            }
            if (arg.equalsIgnoreCase("sql")) {
                this.printSQL = true;
                continue;
            }
            if (arg.equalsIgnoreCase("plan")) {
                this.printPlan = true;
                continue;
            }
            throw new CmdException("Not a recognized print form: " + arg + " : Choices are: query, prefix, op, sqlNode, sql");
        }
    }

    @Override
    protected void execCmd(List<String> positionalArgs) {
        Query query2 = this.modQuery.getQuery();
        this.compilePrint(this.getStore(), query2);
    }

    private void divider() {
        if (this.needDivider) {
            System.out.println(divider);
        }
        this.needDivider = true;
    }

    private void compilePrint(Store store, Query query2) {
        SDB.getContext().setIfUndef(SDB.annotateGeneratedSQL, true);
        if (!(this.printQuery || this.printOp || this.printSqlNode || this.printSQL || this.printPlan)) {
            this.printSQL = true;
        }
        if (this.isVerbose()) {
            this.printOp = true;
            this.printSQL = true;
        }
        if (this.printQuery) {
            this.divider();
            query2.serialize(System.out, Syntax.syntaxARQ);
        }
        QueryEngineSDB qe = new QueryEngineSDB(store, query2);
        Op op = qe.getOp();
        if (this.printOp) {
            this.divider();
            PrintSDB.print(op);
        }
        if (this.printSqlNode) {
            this.divider();
            PrintSDB.printSqlNodes(op);
        }
        if (this.printSQL) {
            this.divider();
            PrintSDB.printSQL(op);
        }
        if (this.printPlan) {
            this.divider();
            System.out.print(qe.getPlan());
        }
    }

    @Override
    protected String getSummary() {
        return "Usage: [--layout schemaName] [--query URL | string ] ";
    }

    @Override
    protected String getCommandName() {
        return Lib.className(this);
    }
}

