/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.Query;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.ARQNotImplemented;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingOutputStream;
import org.apache.jena.sparql.engine.binding.BindingUtils;
import org.apache.jena.sparql.resultset.CSVOutput;
import org.apache.jena.sparql.resultset.JSONOutput;
import org.apache.jena.sparql.resultset.RDFOutput;
import org.apache.jena.sparql.resultset.ResultsFormat;
import org.apache.jena.sparql.resultset.TSVOutput;
import org.apache.jena.sparql.resultset.TextOutput;
import org.apache.jena.sparql.resultset.XMLOutput;
import org.apache.jena.sparql.resultset.XMLOutputASK;
import org.apache.jena.sparql.serializer.SerializationContext;

public class ResultSetFormatter {
    private ResultSetFormatter() {
    }

    public static void out(ResultSet qresults) {
        ResultSetFormatter.out((OutputStream)System.out, qresults);
    }

    public static void out(OutputStream out, ResultSet qresults) {
        ResultSetFormatter.out(out, qresults, (PrefixMapping)null);
    }

    public static void out(ResultSet qresults, Query query2) {
        ResultSetFormatter.out((OutputStream)System.out, qresults, query2);
    }

    public static void out(ResultSet qresults, Prologue prologue) {
        ResultSetFormatter.out((OutputStream)System.out, qresults, prologue);
    }

    public static void out(ResultSet qresults, PrefixMapping pmap) {
        ResultSetFormatter.out((OutputStream)System.out, qresults, pmap);
    }

    public static void out(OutputStream out, ResultSet qresults, PrefixMapping pmap) {
        TextOutput tFmt = new TextOutput(pmap);
        tFmt.format(out, qresults);
    }

    public static void out(OutputStream out, ResultSet qresults, Prologue prologue) {
        TextOutput tFmt = new TextOutput(prologue);
        tFmt.format(out, qresults);
    }

    public static void out(boolean answer) {
        ResultSetFormatter.out((OutputStream)System.out, answer);
    }

    public static void out(OutputStream out, boolean answer) {
        TextOutput tFmt = new TextOutput((SerializationContext)null);
        tFmt.format(out, answer);
    }

    public static String asText(ResultSet qresults) {
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ResultSetFormatter.out((OutputStream)arr, qresults);
        return new String(arr.toByteArray(), StandardCharsets.UTF_8);
    }

    public static String asText(ResultSet qresults, Prologue prologue) {
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ResultSetFormatter.out((OutputStream)arr, qresults, prologue);
        try {
            return new String(arr.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            Log.warn(ResultSetFormatter.class, "UnsupportedEncodingException");
            return null;
        }
    }

    public static int consume(ResultSet resultSet) {
        int count = 0;
        while (resultSet.hasNext()) {
            QuerySolution result = resultSet.nextSolution();
            ResultSetFormatter.materialize(result);
            ++count;
        }
        return count;
    }

    public static List<QuerySolution> toList(ResultSet resultSet) {
        ArrayList<QuerySolution> list = new ArrayList<QuerySolution>();
        while (resultSet.hasNext()) {
            QuerySolution result = resultSet.nextSolution();
            ResultSetFormatter.materialize(result);
            list.add(result);
        }
        return list;
    }

    private static void materialize(QuerySolution qs) {
        Iterator<String> iter = qs.varNames();
        while (iter.hasNext()) {
            String vn = iter.next();
            RDFNode rDFNode = qs.get(vn);
        }
    }

    public static void output(ResultSet resultSet, ResultsFormat rFmt) {
        ResultSetFormatter.output(System.out, resultSet, rFmt);
    }

    public static void output(OutputStream outStream, ResultSet resultSet, ResultsFormat rFmt) {
        if (rFmt.equals(ResultsFormat.FMT_RS_XML)) {
            ResultSetFormatter.outputAsXML(outStream, resultSet);
            return;
        }
        if (rFmt.equals(ResultsFormat.FMT_RS_JSON)) {
            ResultSetFormatter.outputAsJSON(outStream, resultSet);
            return;
        }
        if (rFmt.equals(ResultsFormat.FMT_RS_CSV)) {
            ResultSetFormatter.outputAsCSV(outStream, resultSet);
            return;
        }
        if (rFmt.equals(ResultsFormat.FMT_RS_TSV)) {
            ResultSetFormatter.outputAsTSV(outStream, resultSet);
            return;
        }
        if (rFmt.equals(ResultsFormat.FMT_RS_BIO)) {
            ResultSetFormatter.outputAsBIO(outStream, resultSet);
            return;
        }
        if (rFmt.equals(ResultsFormat.FMT_RDF_XML)) {
            RDFOutput.outputAsRDF(outStream, "RDF/XML-ABBREV", resultSet);
            return;
        }
        if (rFmt.equals(ResultsFormat.FMT_RDF_TTL)) {
            RDFOutput.outputAsRDF(outStream, "TTL", resultSet);
            return;
        }
        if (rFmt.equals(ResultsFormat.FMT_RDF_NT)) {
            RDFOutput.outputAsRDF(outStream, "N-TRIPLES", resultSet);
            return;
        }
        throw new ARQException("Unknown ResultSet format: " + rFmt);
    }

    public static void outputAsXML(ResultSet qresults) {
        ResultSetFormatter.outputAsXML((OutputStream)System.out, qresults);
    }

    public static void outputAsXML(OutputStream outStream, ResultSet qresults) {
        ResultSetFormatter.outputAsXML(outStream, qresults, (String)null);
    }

    public static void outputAsXML(ResultSet qresults, String stylesheet) {
        ResultSetFormatter.outputAsXML((OutputStream)System.out, qresults, stylesheet);
    }

    public static void outputAsXML(OutputStream outStream, ResultSet qresults, String stylesheet) {
        XMLOutput xOut = new XMLOutput(stylesheet);
        xOut.format(outStream, qresults);
    }

    public static void outputAsXML(boolean booleanResult) {
        ResultSetFormatter.outputAsXML((OutputStream)System.out, booleanResult);
    }

    public static void outputAsXML(OutputStream outStream, boolean booleanResult) {
        ResultSetFormatter.outputAsXML(outStream, booleanResult, null);
    }

    public static void outputAsXML(boolean booleanResult, String stylesheet) {
        ResultSetFormatter.outputAsXML((OutputStream)System.out, booleanResult, stylesheet);
    }

    public static void outputAsXML(OutputStream outStream, boolean booleanResult, String stylesheet) {
        XMLOutputASK fmt = new XMLOutputASK(outStream, stylesheet);
        fmt.exec(booleanResult);
    }

    public static String asXMLString(ResultSet qresults) {
        return ResultSetFormatter.asXMLString(qresults, null);
    }

    public static String asXMLString(ResultSet qresults, String stylesheet) {
        XMLOutput xOut = new XMLOutput(stylesheet);
        return xOut.asString(qresults);
    }

    public static String asXMLString(boolean booleanResult) {
        return ResultSetFormatter.asXMLString(booleanResult, null);
    }

    public static String asXMLString(boolean booleanResult, String stylesheet) {
        XMLOutput xOut = new XMLOutput(stylesheet);
        return xOut.asString(booleanResult);
    }

    public static void outputAsJSON(ResultSet resultSet) {
        ResultSetFormatter.outputAsJSON((OutputStream)System.out, resultSet);
    }

    public static void outputAsJSON(OutputStream outStream, ResultSet resultSet) {
        JSONOutput jOut = new JSONOutput();
        jOut.format(outStream, resultSet);
    }

    public static void outputAsJSON(boolean booleanResult) {
        ResultSetFormatter.outputAsJSON((OutputStream)System.out, booleanResult);
    }

    public static void outputAsJSON(OutputStream outStream, boolean booleanResult) {
        JSONOutput jOut = new JSONOutput();
        jOut.format(outStream, booleanResult);
    }

    public static void outputAsSSE(boolean booleanResult) {
        ResultSetFormatter.outputAsSSE((OutputStream)System.out, booleanResult);
    }

    public static void outputAsSSE(OutputStream outStream, boolean booleanResult) {
        throw new ARQNotImplemented("outputAsSSE");
    }

    public static void outputAsSSE(ResultSet resultSet) {
        ResultSetFormatter.outputAsSSE((OutputStream)System.out, resultSet);
    }

    public static void outputAsSSE(ResultSet resultSet, Prologue prologue) {
        ResultSetFormatter.outputAsSSE(System.out, resultSet, prologue);
    }

    public static void outputAsSSE(OutputStream outStream, ResultSet resultSet) {
        ResultSetFormatter.outputAsSSE(outStream, resultSet, null);
    }

    public static void outputAsSSE(OutputStream outStream, ResultSet resultSet, Prologue prologue) {
        throw new ARQNotImplemented("outputAsSSE");
    }

    public static void outputAsCSV(boolean booleanResult) {
        ResultSetFormatter.outputAsCSV((OutputStream)System.out, booleanResult);
    }

    public static void outputAsCSV(OutputStream outStream, boolean booleanResult) {
        CSVOutput fmt = new CSVOutput();
        fmt.format(outStream, booleanResult);
    }

    public static void outputAsCSV(ResultSet resultSet) {
        ResultSetFormatter.outputAsCSV((OutputStream)System.out, resultSet);
    }

    public static void outputAsCSV(OutputStream outStream, ResultSet resultSet) {
        CSVOutput fmt = new CSVOutput();
        fmt.format(outStream, resultSet);
    }

    public static void outputAsTSV(boolean booleanResult) {
        ResultSetFormatter.outputAsTSV((OutputStream)System.out, booleanResult);
    }

    public static void outputAsTSV(OutputStream outStream, boolean booleanResult) {
        TSVOutput fmt = new TSVOutput();
        fmt.format(outStream, booleanResult);
    }

    public static void outputAsTSV(ResultSet resultSet) {
        ResultSetFormatter.outputAsTSV((OutputStream)System.out, resultSet);
    }

    public static void outputAsTSV(OutputStream outStream, ResultSet resultSet) {
        TSVOutput fmt = new TSVOutput();
        fmt.format(outStream, resultSet);
    }

    @Deprecated
    public static void outputAsBIO(OutputStream out, ResultSet results) {
        List<Var> vars = Var.varList(results.getResultVars());
        BindingOutputStream bout = new BindingOutputStream(out, vars);
        while (results.hasNext()) {
            Binding b = BindingUtils.asBinding(results.next());
            bout.write(b);
        }
        bout.flush();
    }
}

