/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.iri.IRI;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.checker.CheckerIRI;
import org.apache.jena.riot.checker.CheckerLiterals;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.FactoryRDF;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.FmtUtils;

public class ParserProfileStd
implements ParserProfile {
    private final FactoryRDF factory;
    private final ErrorHandler errorHandler;
    private final Context context;
    private IRIResolver resolver;
    private final PrefixMap prefixMap;
    private final boolean strictMode;
    private final boolean checking;

    public ParserProfileStd(FactoryRDF factory, ErrorHandler errorHandler, IRIResolver resolver, PrefixMap prefixMap, Context context, boolean checking, boolean strictMode) {
        this.factory = factory;
        this.errorHandler = errorHandler;
        this.resolver = resolver;
        this.prefixMap = prefixMap;
        this.context = context;
        this.checking = checking;
        this.strictMode = strictMode;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public boolean isStrictMode() {
        return this.strictMode;
    }

    @Override
    public String resolveIRI(String uriStr, long line, long col) {
        return this.makeIRI(uriStr, line, col).toString();
    }

    @Override
    public void setIRIResolver(IRIResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public IRI makeIRI(String uriStr, long line, long col) {
        IRI iri2 = this.resolver.resolveSilent(uriStr);
        if (uriStr.contains(" ")) {
            this.errorHandler.warning("Bad IRI: <" + uriStr + "> Spaces are not legal in URIs/IRIs.", line, col);
            return iri2;
        }
        if (!this.checking) {
            return iri2;
        }
        CheckerIRI.iriViolations(iri2, this.errorHandler, line, col);
        return iri2;
    }

    @Override
    public Triple createTriple(Node subject, Node predicate, Node object, long line, long col) {
        if (this.checking) {
            this.checkTriple(subject, predicate, object, line, col);
        }
        return this.factory.createTriple(subject, predicate, object);
    }

    @Override
    public Quad createQuad(Node graph, Node subject, Node predicate, Node object, long line, long col) {
        if (this.checking) {
            this.checkQuad(graph, subject, predicate, object, line, col);
        }
        return this.factory.createQuad(graph, subject, predicate, object);
    }

    @Override
    public Node createURI(String x, long line, long col) {
        if (!RiotLib.isBNodeIRI(x) && !RiotLib.isPrefixIRI(x)) {
            x = this.resolveIRI(x, line, col);
        }
        return this.factory.createURI(x);
    }

    @Override
    public Node createTypedLiteral(String lexical, RDFDatatype datatype, long line, long col) {
        if (this.checking) {
            CheckerLiterals.checkLiteral(lexical, datatype, this.errorHandler, line, col);
        }
        return this.factory.createTypedLiteral(lexical, datatype);
    }

    @Override
    public Node createLangLiteral(String lexical, String langTag, long line, long col) {
        if (this.checking) {
            CheckerLiterals.checkLiteral(lexical, langTag, this.errorHandler, line, col);
        }
        return this.factory.createLangLiteral(lexical, langTag);
    }

    @Override
    public Node createStringLiteral(String lexical, long line, long col) {
        return this.factory.createStringLiteral(lexical);
    }

    @Override
    public Node createNodeFromToken(Node scope, Token token, long line, long col) {
        return null;
    }

    @Override
    public Node createBlankNode(Node scope, String label, long line, long col) {
        return this.factory.createBlankNode(label);
    }

    @Override
    public Node createBlankNode(Node scope, long line, long col) {
        return this.factory.createBlankNode();
    }

    @Override
    public Node create(Node currentGraph, Token token) {
        long line = token.getLine();
        long col = token.getColumn();
        String str2 = token.getImage();
        switch (token.getType()) {
            case BNODE: {
                return this.createBlankNode(currentGraph, str2, line, col);
            }
            case IRI: {
                return this.createURI(str2, line, col);
            }
            case PREFIXED_NAME: {
                String prefix = str2;
                String suffix = token.getImage2();
                String expansion = this.expandPrefixedName(prefix, suffix, token);
                return this.createURI(expansion, line, col);
            }
            case DECIMAL: {
                return this.createTypedLiteral(str2, XSDDatatype.XSDdecimal, line, col);
            }
            case DOUBLE: {
                return this.createTypedLiteral(str2, XSDDatatype.XSDdouble, line, col);
            }
            case INTEGER: {
                return this.createTypedLiteral(str2, XSDDatatype.XSDinteger, line, col);
            }
            case LITERAL_DT: {
                String uriStr;
                Token tokenDT = token.getSubToken2();
                switch (tokenDT.getType()) {
                    case IRI: {
                        uriStr = tokenDT.getImage();
                        break;
                    }
                    case PREFIXED_NAME: {
                        String prefix = tokenDT.getImage();
                        String suffix = tokenDT.getImage2();
                        uriStr = this.expandPrefixedName(prefix, suffix, tokenDT);
                        break;
                    }
                    default: {
                        throw new RiotException("Expected IRI for datatype: " + token);
                    }
                }
                uriStr = this.resolveIRI(uriStr, tokenDT.getLine(), tokenDT.getColumn());
                RDFDatatype dt = NodeFactory.getType(uriStr);
                return this.createTypedLiteral(str2, dt, line, col);
            }
            case LITERAL_LANG: {
                return this.createLangLiteral(str2, token.getImage2(), line, col);
            }
            case STRING: {
                return this.createStringLiteral(str2, line, col);
            }
            case BOOLEAN: {
                return this.createTypedLiteral(str2, XSDDatatype.XSDboolean, line, col);
            }
        }
        Node x = this.createNodeFromToken(currentGraph, token, line, col);
        if (x != null) {
            return x;
        }
        this.errorHandler.fatal("Not a valid token for an RDF term: " + token, line, col);
        return null;
    }

    @Override
    public PrefixMap getPrefixMap() {
        return this.prefixMap;
    }

    private String expandPrefixedName(String prefix, String localPart, Token token) {
        String expansion = this.prefixMap.expand(prefix, localPart);
        if (expansion == null) {
            if (ARQ.isTrue(ARQ.fixupUndefinedPrefixes)) {
                return RiotLib.fixupPrefixIRI(prefix, localPart);
            }
            this.errorHandler.fatal("Undefined prefix: " + prefix, token.getLine(), token.getColumn());
        }
        return expansion;
    }

    private void checkTriple(Node subject, Node predicate, Node object, long line, long col) {
        if (subject == null || !subject.isURI() && !subject.isBlank()) {
            this.errorHandler.error("Subject is not a URI or blank node", line, col);
            throw new RiotException("Bad subject: " + subject);
        }
        if (predicate == null || !predicate.isURI()) {
            this.errorHandler.error("Predicate not a URI", line, col);
            throw new RiotException("Bad predicate: " + predicate);
        }
        if (object == null || !object.isURI() && !object.isBlank() && !object.isLiteral()) {
            this.errorHandler.error("Object is not a URI, blank node or literal", line, col);
            throw new RiotException("Bad object: " + object);
        }
    }

    private void checkQuad(Node graph, Node subject, Node predicate, Node object, long line, long col) {
        if (graph != null && !graph.isURI() && !graph.isBlank()) {
            this.errorHandler.error("Graph name is not a URI or blank node: " + FmtUtils.stringForNode(graph), line, col);
            throw new RiotException("Bad graph name: " + graph);
        }
        this.checkTriple(subject, predicate, object, line, col);
    }
}

