/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import org.apache.jena.graph.Node;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.SNode;
import org.apache.jena.riot.system.SQuad;
import org.apache.jena.riot.system.STriple;
import org.apache.jena.riot.system.Serializer;
import org.apache.jena.riot.thrift.TRDF;
import org.apache.jena.riot.thrift.ThriftConvert;
import org.apache.jena.riot.thrift.wire.RDF_Term;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;

public class SerializerRDF {
    private static final PrefixMap pmap = null;
    private static final boolean encodeValues = false;

    public static void init() {
        org.apache.jena.system.Serializer.setNodeSerializer(SNode::new);
        org.apache.jena.system.Serializer.setTripleSerializer(STriple::new);
        Serializer.setQuadSerializer(SQuad::new);
    }

    static Node read(TProtocol protocol, RDF_Term tterm) {
        tterm.clear();
        try {
            tterm.read(protocol);
        }
        catch (TException e2) {
            TRDF.exception(e2);
        }
        return ThriftConvert.convert(tterm);
    }

    static void write(TProtocol protocol, RDF_Term tterm, Node node) {
        tterm.clear();
        ThriftConvert.toThrift(node, pmap, tterm, false);
        try {
            tterm.write(protocol);
        }
        catch (TException e2) {
            TRDF.exception(e2);
        }
    }
}

