/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.assembler;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sdb.assembler.AssemblerVocab;
import org.apache.jena.sdb.shared.Access;
import org.apache.jena.sdb.sql.SDBConnectionDesc;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.vocabulary.RDFS;

public class SDBConnectionDescAssembler
extends AssemblerBase
implements Assembler {
    @Override
    public SDBConnectionDesc open(Assembler a, Resource root2, Mode mode) {
        SDBConnectionDesc sDesc = SDBConnectionDesc.blank();
        sDesc.setType(GraphUtils.getStringValue(root2, AssemblerVocab.pSDBtype));
        sDesc.setHost(GraphUtils.getStringValue(root2, AssemblerVocab.pSDBhost));
        sDesc.setName(GraphUtils.getStringValue(root2, AssemblerVocab.pSDBname));
        sDesc.setUser(GraphUtils.getStringValue(root2, AssemblerVocab.pSDBuser));
        sDesc.setPassword(GraphUtils.getStringValue(root2, AssemblerVocab.pSDBpassword));
        sDesc.setDriver(GraphUtils.getStringValue(root2, AssemblerVocab.pDriver));
        sDesc.setJdbcURL(GraphUtils.getStringValue(root2, AssemblerVocab.pJDBC));
        sDesc.setPoolSize(GraphUtils.getStringValue(root2, AssemblerVocab.pPoolSize));
        sDesc.setLabel(GraphUtils.getStringValue(root2, RDFS.label));
        if (sDesc.getUser() == null) {
            sDesc.setUser(Access.getUser());
        }
        if (sDesc.getPassword() == null) {
            sDesc.setPassword(Access.getPassword());
        }
        return sDesc;
    }
}

