/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.compiler;

import org.apache.jena.sdb.SDB;
import org.apache.jena.sdb.compiler.PatternTable;
import org.apache.jena.sdb.compiler.QuadBlock;
import org.apache.jena.sdb.compiler.QuadBlockCompiler;
import org.apache.jena.sdb.compiler.SlotCompiler;
import org.apache.jena.sdb.compiler.SqlBuilder;
import org.apache.jena.sdb.compiler.SqlStage;
import org.apache.jena.sdb.compiler.SqlStageBasicQuad;
import org.apache.jena.sdb.compiler.SqlStageList;
import org.apache.jena.sdb.core.SDBRequest;
import org.apache.jena.sdb.core.sqlnode.SqlNode;
import org.apache.jena.sdb.shared.SDBInternalError;
import org.apache.jena.sparql.core.Quad;

public class QuadBlockCompilerMain
implements QuadBlockCompiler {
    SDBRequest request;
    SlotCompiler slotCompiler;
    public static PatternTable patternTable = null;

    public QuadBlockCompilerMain(SDBRequest request, SlotCompiler slotCompiler) {
        this.request = request;
        this.slotCompiler = slotCompiler;
    }

    @Override
    public SlotCompiler getSlotCompiler() {
        return this.slotCompiler;
    }

    @Override
    public final SqlNode compile(QuadBlock quads) {
        SqlNode sqlNode = this.slotCompiler.start(quads);
        quads = new QuadBlock(quads);
        SqlStageList sList = new SqlStageList();
        int i = 0;
        while (i < quads.size()) {
            SqlStage stage;
            Quad q = (Quad)quads.get(i);
            if (patternTable != null && patternTable.trigger(q) && (stage = patternTable.process(i, quads)) != null) {
                if (quads.get(i) == q) {
                    throw new SDBInternalError("Pattern table returned a stage but did not remove the first quad");
                }
                sList.add(stage);
                continue;
            }
            sList.add(new SqlStageBasicQuad(q));
            ++i;
        }
        SqlNode sqlStages = sList.build(this.request, this.slotCompiler);
        sqlNode = SqlBuilder.innerJoin(this.request, sqlNode, sqlStages);
        sqlNode = this.slotCompiler.finish(sqlNode, quads);
        boolean needDistinct = false;
        if (quads.getGraphNode().equals(Quad.unionGraph)) {
            needDistinct = true;
        } else if (Quad.isDefaultGraphGenerated(quads.getGraphNode()) && this.request.getContext().isTrue(SDB.unionDefaultGraph)) {
            needDistinct = true;
        }
        if (needDistinct) {
            String renameName = this.request.genId("A");
            sqlNode = SqlBuilder.view(this.request, sqlNode);
            sqlNode = SqlBuilder.distinct(this.request, sqlNode);
        }
        return sqlNode;
    }
}

