/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.compiler;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.sdb.SDB;
import org.apache.jena.sdb.compiler.SlotCompiler;
import org.apache.jena.sdb.compiler.SqlBuilder;
import org.apache.jena.sdb.compiler.SqlStage;
import org.apache.jena.sdb.core.SDBRequest;
import org.apache.jena.sdb.core.sqlexpr.SqlExprList;
import org.apache.jena.sdb.core.sqlnode.SqlNode;
import org.apache.jena.sdb.core.sqlnode.SqlTable;
import org.apache.jena.sdb.layout2.TableDescQuads;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.FmtUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlStageBasicQuad
implements SqlStage {
    private static Logger log = LoggerFactory.getLogger(SqlStageBasicQuad.class);
    private Quad quad;

    public SqlStageBasicQuad(Quad quad) {
        this.quad = quad;
    }

    @Override
    public SqlNode build(SDBRequest request, SlotCompiler slotCompiler) {
        SqlExprList conditions = new SqlExprList();
        boolean defaultGraph = Quad.isDefaultGraph(this.quad.getGraph());
        boolean unionGraph = this.quad.isUnionGraph();
        boolean accessStoredDefaultGraph = Quad.isDefaultGraph(this.quad.getGraph());
        boolean accessUnionGraph = false;
        if (accessStoredDefaultGraph && request.getContext().isTrue(SDB.unionDefaultGraph)) {
            defaultGraph = false;
            unionGraph = true;
            accessStoredDefaultGraph = false;
            accessUnionGraph = true;
        }
        if (this.quad.isDefaultGraphExplicit()) {
            accessStoredDefaultGraph = true;
            accessUnionGraph = false;
        }
        if (this.quad.isUnionGraph()) {
            accessStoredDefaultGraph = false;
            accessUnionGraph = true;
        }
        TableDescQuads tableDesc = null;
        String alias = null;
        if (accessStoredDefaultGraph) {
            tableDesc = request.getStore().getTripleTableDesc();
            alias = request.genId("T");
        } else {
            tableDesc = request.getStore().getQuadTableDesc();
            alias = request.genId("Q");
        }
        SqlTable table = new SqlTable(alias, tableDesc.getTableName());
        if (accessStoredDefaultGraph) {
            table.addNote(FmtUtils.stringForTriple(this.quad.asTriple(), request.getPrefixMapping()));
        } else {
            table.addNote(FmtUtils.stringForQuad(this.quad, request.getPrefixMapping()));
        }
        if (!accessStoredDefaultGraph && !accessUnionGraph) {
            slotCompiler.processSlot(request, table, conditions, this.quad.getGraph(), tableDesc.getGraphColName());
        }
        slotCompiler.processSlot(request, table, conditions, this.quad.getSubject(), tableDesc.getSubjectColName());
        slotCompiler.processSlot(request, table, conditions, this.quad.getPredicate(), tableDesc.getPredicateColName());
        slotCompiler.processSlot(request, table, conditions, this.quad.getObject(), tableDesc.getObjectColName());
        return SqlBuilder.restrict(request, (SqlNode)table, conditions);
    }

    public String toString() {
        return "Table: " + this.quad;
    }

    @Override
    public void output(IndentedWriter out) {
        out.print(this.toString());
    }
}

