/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.core;

import org.apache.jena.sdb.exprmatch.ActionMatch;
import org.apache.jena.sdb.exprmatch.ExprMatcher;
import org.apache.jena.sdb.exprmatch.MapAction;
import org.apache.jena.sdb.exprmatch.MapResult;
import org.apache.jena.sdb.shared.SDBInternalError;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.util.ExprUtils;

public class ExprPattern {
    Expr pattern;
    MapAction mapAction;

    public ExprPattern(String pattern, Var[] vars, ActionMatch[] actions) {
        this.pattern = ExprUtils.parse(pattern);
        if (vars.length != actions.length) {
            throw new SDBInternalError("Variable and action arrays are different lengths");
        }
        this.mapAction = new MapAction();
        for (int i = 0; i < vars.length; ++i) {
            Var var = vars[i];
            ActionMatch a = actions[i];
            this.mapAction.put(var, a);
        }
    }

    public MapResult match(Expr expression) {
        return ExprMatcher.match(expression, this.pattern, this.mapAction);
    }
}

