/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.graph;

import java.util.Iterator;
import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEventManager;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.AllCapabilities;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.sdb.SDB;
import org.apache.jena.sdb.Store;
import org.apache.jena.sdb.graph.EventManagerSDB;
import org.apache.jena.sdb.graph.PrefixMappingSDB;
import org.apache.jena.sdb.sql.SDBConnection;
import org.apache.jena.sdb.store.DatasetGraphSDB;
import org.apache.jena.sdb.store.LibSDB;
import org.apache.jena.sdb.store.StoreLoader;
import org.apache.jena.sdb.store.StoreLoaderPlus;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphSDB
extends GraphBase
implements Graph {
    private static Logger log = LoggerFactory.getLogger(GraphSDB.class);
    protected Store store = null;
    protected int inBulkUpdate = 0;
    protected Node graphNode = Quad.defaultGraphNodeGenerated;
    protected DatasetGraphSDB datasetStore = null;

    public GraphSDB(Store store, String uri) {
        this(store, NodeFactory.createURI(uri));
    }

    public GraphSDB(Store store) {
        this(store, (Node)null);
    }

    public GraphSDB(Store store, Node graphNode) {
        if (graphNode == null) {
            graphNode = Quad.defaultGraphNodeGenerated;
        }
        this.store = store;
        this.graphNode = graphNode;
        this.datasetStore = new DatasetGraphSDB(store, this, SDB.getContext().copy());
    }

    @Override
    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new AllCapabilities(){

                @Override
                public boolean handlesLiteralTyping() {
                    return false;
                }
            };
        }
        return this.capabilities;
    }

    public Store getStore() {
        return this.store;
    }

    public SDBConnection getConnection() {
        return this.store.getConnection();
    }

    @Override
    public PrefixMapping createPrefixMapping() {
        try {
            String graphURI = null;
            if (Quad.isDefaultGraphGenerated(this.graphNode)) {
                graphURI = "";
            } else if (this.graphNode.isURI()) {
                graphURI = this.graphNode.getURI();
            } else {
                log.warn("Not a URI for graph name");
                graphURI = this.graphNode.toString();
            }
            return new PrefixMappingSDB(graphURI, this.store.getConnection());
        }
        catch (Exception ex) {
            log.warn("Failed to get prefixes: " + ex.getMessage());
            return null;
        }
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(Triple m) {
        Iterator<Triple> iter = LibSDB.findTriples(this.datasetStore, this.graphNode, m.getSubject(), m.getPredicate(), m.getObject());
        return WrappedIterator.create(iter);
    }

    public StoreLoader getBulkLoader() {
        return this.store.getLoader();
    }

    @Override
    public GraphEventManager getEventManager() {
        if (this.gem == null) {
            this.gem = new EventManagerSDB();
        }
        return this.gem;
    }

    @Override
    public void performAdd(Triple triple) {
        if (this.inBulkUpdate == 0) {
            this.store.getLoader().startBulkUpdate();
        }
        if (Quad.isDefaultGraphGenerated(this.graphNode)) {
            this.store.getLoader().addTriple(triple);
        } else {
            StoreLoaderPlus x = (StoreLoaderPlus)this.store.getLoader();
            x.addQuad(this.graphNode, triple.getSubject(), triple.getPredicate(), triple.getObject());
        }
        if (this.inBulkUpdate == 0) {
            this.store.getLoader().finishBulkUpdate();
        }
    }

    @Override
    public void performDelete(Triple triple) {
        if (this.inBulkUpdate == 0) {
            this.store.getLoader().startBulkUpdate();
        }
        if (Quad.isDefaultGraphGenerated(this.graphNode)) {
            this.store.getLoader().deleteTriple(triple);
        } else {
            StoreLoaderPlus x = (StoreLoaderPlus)this.store.getLoader();
            x.deleteQuad(this.graphNode, triple.getSubject(), triple.getPredicate(), triple.getObject());
        }
        if (this.inBulkUpdate == 0) {
            this.store.getLoader().finishBulkUpdate();
        }
    }

    public void startBulkUpdate() {
        ++this.inBulkUpdate;
        if (this.inBulkUpdate == 1) {
            this.store.getLoader().startBulkUpdate();
        }
    }

    public void finishBulkUpdate() {
        --this.inBulkUpdate;
        if (this.inBulkUpdate == 0) {
            this.store.getLoader().finishBulkUpdate();
        }
    }

    @Override
    public TransactionHandler getTransactionHandler() {
        return this.store.getConnection().getTransactionHandler();
    }

    @Override
    public int graphBaseSize() {
        return (int)(Quad.isDefaultGraphGenerated(this.graphNode) ? this.store.getSize() : this.store.getSize(this.graphNode));
    }

    public void deleteAll() {
        if (this.inBulkUpdate == 0) {
            this.store.getLoader().startBulkUpdate();
        }
        if (Quad.isDefaultGraphGenerated(this.graphNode)) {
            this.store.getLoader().deleteAll();
        } else {
            ((StoreLoaderPlus)this.store.getLoader()).deleteAll(this.graphNode);
        }
        if (this.inBulkUpdate == 0) {
            this.store.getLoader().finishBulkUpdate();
        }
    }
}

