/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.graph;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.jena.graph.impl.TransactionHandlerBase;
import org.apache.jena.sdb.SDBException;
import org.apache.jena.sdb.sql.SDBConnection;
import org.apache.jena.sdb.sql.SDBExceptionSQL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionHandlerSDB
extends TransactionHandlerBase {
    private static Logger log = LoggerFactory.getLogger(TransactionHandlerSDB.class);
    protected Connection sqlConnection;
    protected volatile boolean inTransaction;

    public TransactionHandlerSDB(SDBConnection connection) {
        this.sqlConnection = connection.getSqlConnection();
        this.inTransaction = false;
    }

    @Override
    public boolean transactionsSupported() {
        return true;
    }

    @Override
    public synchronized void begin() {
        if (this.inTransaction) {
            log.warn("beginTransaction: Already in a transaction");
            throw new SDBException("Already in transaction");
        }
        try {
            this.sqlConnection.setAutoCommit(false);
            this.inTransaction = true;
        }
        catch (SQLException ex) {
            new SDBExceptionSQL("begin", ex);
        }
    }

    @Override
    public synchronized void commit() {
        if (!this.inTransaction) {
            log.warn("commit: Not in a transaction");
            return;
        }
        try {
            this.sqlConnection.commit();
            this.sqlConnection.setAutoCommit(true);
            this.inTransaction = false;
        }
        catch (SQLException ex) {
            new SDBExceptionSQL("commit", ex);
        }
    }

    @Override
    public synchronized void abort() {
        if (!this.inTransaction) {
            log.warn("abort: Not in a transaction");
            return;
        }
        try {
            this.sqlConnection.rollback();
            this.sqlConnection.setAutoCommit(true);
            this.inTransaction = false;
        }
        catch (SQLException ex) {
            new SDBExceptionSQL("abort", ex);
        }
    }

    public synchronized void abortFinally() {
        if (!this.inTransaction) {
            return;
        }
        this.abort();
    }

    public void abortSilent() {
        try {
            this.abortFinally();
        }
        catch (SDBExceptionSQL sDBExceptionSQL) {
            // empty catch block
        }
    }
}

