/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.layout2;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.apache.jena.sdb.core.SDBRequest;
import org.apache.jena.sdb.core.sqlexpr.SqlColumn;
import org.apache.jena.sdb.core.sqlnode.SqlNode;
import org.apache.jena.sdb.core.sqlnode.SqlTable;
import org.apache.jena.sdb.layout2.SQLBridge2;
import org.apache.jena.sdb.sql.SQLUtils;
import org.apache.jena.sparql.core.Var;

public class SQLBridge2Oracle
extends SQLBridge2 {
    public SQLBridge2Oracle(SDBRequest request, SqlNode sqlNode, Collection<Var> projectVars) {
        super(request, sqlNode, projectVars);
    }

    @Override
    protected SqlColumn getLexSqlColumn(SqlTable table) {
        return new SqlColumn(table, "lex"){

            @Override
            public String getFullColumnName() {
                String col = this.getTable().getAliasName() + "." + this.getColumnName();
                return "CASE WHEN LENGTH(" + col + ") <= 2000 THEN NULL ELSE " + col + " END";
            }
        };
    }

    @Override
    protected SqlColumn getLexNCharSqlColumn(SqlTable table) {
        return new SqlColumn(table, "lexNChar"){

            @Override
            public String getFullColumnName() {
                String col = this.getTable().getAliasName() + ".lex";
                return "CASE WHEN LENGTH(" + col + ") <= 2000 THEN TO_NCHAR(" + col + ") ELSE NULL END ";
            }
        };
    }

    @Override
    protected String getLexFromResultSet(ResultSet rs, String codename) throws SQLException {
        String lex = rs.getString(SQLUtils.gen(codename, "lexNChar"));
        if (lex == null) {
            rs.getString(SQLUtils.gen(codename, "lex"));
        }
        if (lex == null) {
            lex = "";
        }
        return lex;
    }
}

