/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.layout2.hash;

import java.sql.SQLException;
import org.apache.jena.sdb.layout2.FmtLayout2;
import org.apache.jena.sdb.layout2.TableDescNodes;
import org.apache.jena.sdb.layout2.TableDescQuads;
import org.apache.jena.sdb.layout2.TableDescTriples;
import org.apache.jena.sdb.layout2.TablePrefixes;
import org.apache.jena.sdb.sql.SAPStorageType;
import org.apache.jena.sdb.sql.SDBConnection;
import org.apache.jena.sdb.sql.SDBExceptionSQL;
import org.apache.jena.sdb.sql.SQLUtils;

public class FmtLayout2HashSAP
extends FmtLayout2 {
    protected SAPStorageType storageType;

    public FmtLayout2HashSAP(SDBConnection connection, SAPStorageType storageType) {
        super(connection);
        this.storageType = storageType;
    }

    @Override
    protected void formatTableTriples() {
        String tname = TableDescTriples.name();
        this.dropTable(tname);
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE " + this.storageType.getStorageName() + " TABLE " + tname + " (", "    s BIGINT NOT NULL,", "    p BIGINT NOT NULL,", "    o BIGINT NOT NULL", ")"));
            this.connection().exec(SQLUtils.sqlStr("ALTER TABLE " + tname + " ADD PRIMARY KEY (s, p, o)"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescTriples.name() + "'", ex);
        }
    }

    @Override
    protected void formatTableQuads() {
        String tname = TableDescQuads.name();
        this.dropTable(tname);
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE " + this.storageType.getStorageName() + " TABLE " + tname + " (", "    g BIGINT NOT NULL,", "    s BIGINT NOT NULL,", "    p BIGINT NOT NULL,", "    o BIGINT NOT NULL", ")"));
            this.connection().exec(SQLUtils.sqlStr("ALTER TABLE " + tname + " ADD PRIMARY KEY (g, s, p, o)"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescTriples.name() + "'", ex);
        }
    }

    @Override
    protected String syntaxDropIndex(String indexName, String table) {
        return String.format("DROP INDEX IF EXISTS %s", indexName);
    }

    @Override
    protected void formatTableNodes() {
        String tname = TableDescNodes.name();
        this.dropTable(tname);
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE " + this.storageType.getStorageName() + " TABLE " + tname + " (", "   hash BIGINT NOT NULL,", "   lex nvarchar(5000) NOT NULL,", "   lang nvarchar (10) NOT NULL default '',", "   datatype nvarchar(200) NOT NULL default '',", "   type integer NOT NULL default '0'", ")"));
            this.connection().exec(SQLUtils.sqlStr("ALTER TABLE " + tname + " ADD PRIMARY KEY (hash)"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException formatting table '" + TableDescNodes.name() + "'", ex);
        }
    }

    @Override
    protected void formatTablePrefixes() {
        String tname = TablePrefixes.name();
        this.dropTable(tname);
        try {
            this.connection().exec(SQLUtils.sqlStr("CREATE " + this.storageType.getStorageName() + " TABLE " + tname + " (", "    prefix NVARCHAR(50) NOT NULL ,", "    uri NVARCHAR(500) NOT NULL", ")"));
            this.connection().exec(SQLUtils.sqlStr("ALTER TABLE " + tname + " ADD CONSTRAINT " + tname + "_PK PRIMARY KEY (prefix)"));
        }
        catch (SQLException ex) {
            throw new SDBExceptionSQL("SQLException resetting table '" + TablePrefixes.name() + "'", ex);
        }
    }
}

