/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.syntax.syntaxtransform;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementAssign;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementDataset;
import org.apache.jena.sparql.syntax.ElementExists;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementMinus;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementNotExists;
import org.apache.jena.sparql.syntax.ElementOptional;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementService;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementUnion;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.sparql.syntax.ElementWalker;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransform;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformIdentity;
import org.apache.jena.sparql.syntax.syntaxtransform.QueryTransformOps;
import org.apache.jena.sparql.syntax.syntaxtransform.TransformElementLib;

class ApplyElementTransformVisitor
implements ElementVisitor {
    protected final ElementTransform transform;
    private final ExprTransform exprTransform;
    private final Deque<Element> stack = new ArrayDeque<Element>();

    protected final Element pop() {
        return this.stack.pop();
    }

    protected final void push(Element elt) {
        this.stack.push(elt);
    }

    public ApplyElementTransformVisitor(ElementTransform transform, ExprTransform exprTransform) {
        if (transform == null) {
            transform = ElementTransformIdentity.get();
        }
        this.transform = transform;
        this.exprTransform = exprTransform;
    }

    final Element result() {
        if (this.stack.size() != 1) {
            Log.warn(this, "Stack is not aligned");
        }
        return this.pop();
    }

    @Override
    public void visit(ElementTriplesBlock el) {
        Element el2 = this.transform.transform(el);
        this.push(el2);
    }

    @Override
    public void visit(ElementPathBlock el) {
        Element el2 = this.transform.transform(el);
        this.push(el2);
    }

    @Override
    public void visit(ElementFilter el) {
        Expr expr = el.getExpr();
        Expr expr2 = this.transformExpr(expr, this.exprTransform);
        Element el2 = this.transform.transform(el, expr2);
        this.push(el2);
    }

    @Override
    public void visit(ElementAssign el) {
        Var v = el.getVar();
        Var v1 = TransformElementLib.applyVar(v, this.exprTransform);
        Expr expr = el.getExpr();
        Expr expr1 = ExprTransformer.transform(this.exprTransform, expr);
        Element el2 = this.transform.transform(el, v1, expr1);
        this.push(el2);
    }

    @Override
    public void visit(ElementBind el) {
        Var v = el.getVar();
        Var v1 = TransformElementLib.applyVar(v, this.exprTransform);
        Expr expr = el.getExpr();
        Expr expr1 = ExprTransformer.transform(this.exprTransform, expr);
        Element el2 = this.transform.transform(el, v1, expr1);
        this.push(el2);
    }

    @Override
    public void visit(ElementData el) {
        this.transform.transform(el);
        this.push(el);
    }

    @Override
    public void visit(ElementOptional el) {
        Element elSub = this.pop();
        Element el2 = this.transform.transform(el, elSub);
        this.push(el2);
    }

    @Override
    public void visit(ElementGroup el) {
        ElementGroup newElt = new ElementGroup();
        boolean b = this.transformFromTo(el.getElements(), newElt.getElements());
        Element el2 = this.transform.transform(el, newElt.getElements());
        this.push(el2);
    }

    @Override
    public void visit(ElementUnion el) {
        ElementUnion newElt = new ElementUnion();
        boolean b = this.transformFromTo(el.getElements(), newElt.getElements());
        Element el2 = this.transform.transform(el, newElt.getElements());
        this.push(el2);
    }

    private boolean transformFromTo(List<Element> elts, List<Element> elts2) {
        boolean changed = false;
        for (Element elt : elts) {
            Element elt2 = this.pop();
            changed = changed || elt != elt2;
            elts2.add(0, elt2);
        }
        return changed;
    }

    @Override
    public void visit(ElementDataset el) {
        Element sub = this.pop();
        Element el2 = this.transform.transform(el, sub);
        this.push(el2);
    }

    @Override
    public void visit(ElementNamedGraph el) {
        Node n = el.getGraphNameNode();
        Node n1 = this.transformNode(n);
        Element elt1 = this.pop();
        Element el2 = this.transform.transform(el, n1, elt1);
        this.push(el2);
    }

    @Override
    public void visit(ElementExists el) {
        Element elt = el.getElement();
        Element elt1 = this.subElement(elt);
        Element el2 = this.transform.transform(el, elt1);
        this.push(el2);
    }

    @Override
    public void visit(ElementNotExists el) {
        Element elt = el.getElement();
        Element elt1 = this.subElement(elt);
        Element el2 = this.transform.transform(el, elt1);
        this.push(el2);
    }

    private Element subElement(Element elt) {
        ElementWalker.walk(elt, this);
        Element elt1 = this.pop();
        return elt1;
    }

    @Override
    public void visit(ElementMinus el) {
        Element elt1;
        Element elt = el.getMinusElement();
        if (elt == (elt1 = this.pop())) {
            this.push(el);
        } else {
            this.push(new ElementMinus(elt1));
        }
    }

    @Override
    public void visit(ElementService el) {
        Node n = el.getServiceNode();
        Node n1 = this.transformNode(n);
        Element elt1 = this.pop();
        Element el2 = this.transform.transform(el, n1, elt1);
        this.push(el2);
    }

    @Override
    public void visit(ElementSubQuery el) {
        Query newQuery = QueryTransformOps.transform(el.getQuery(), this.transform, this.exprTransform);
        this.push(new ElementSubQuery(newQuery));
    }

    private Node transformNode(Node n) {
        if (this.exprTransform == null) {
            return n;
        }
        return TransformElementLib.apply(n, this.exprTransform);
    }

    private ExprList transformExpr(ExprList exprList, ExprTransform exprTransform) {
        if (exprList == null || exprTransform == null) {
            return exprList;
        }
        return ExprTransformer.transform(exprTransform, exprList);
    }

    private Expr transformExpr(Expr expr, ExprTransform exprTransform) {
        if (expr == null || exprTransform == null) {
            return expr;
        }
        return ExprTransformer.transform(exprTransform, expr);
    }
}

