/*
 * Decompiled with CFR 0.152.
 */
package sdb;

import java.util.List;
import jena.cmd.ArgDecl;
import jena.cmd.CmdException;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.lib.ProgressMonitor;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.system.ProgressStreamRDF;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.sdb.SDB;
import org.apache.jena.sdb.SDBFactory;
import org.apache.jena.sdb.Store;
import org.apache.jena.sdb.store.StoreBaseHSQL;
import org.apache.jena.sdb.store.StoreLoaderPlus;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Quad;
import sdb.cmd.CmdArgsDB;
import sdb.cmd.ModGraph;

public class sdbload
extends CmdArgsDB {
    private static final String usage = "sdbload --sdb <SPEC> [--graph=IRI] file";
    private static ModGraph modGraph = new ModGraph();
    private static ArgDecl argDeclTruncate = new ArgDecl(false, "truncate");
    private static ArgDecl argDeclReplace = new ArgDecl(false, "replace");
    String filename = null;
    private static ProgressMonitor.Output output = (fmt, args) -> {
        System.out.printf(fmt, args);
        if (!fmt.endsWith("\n")) {
            System.out.println();
        }
    };

    public static void main(String ... argv) {
        SDB.init();
        new sdbload(argv).mainRun();
    }

    public sdbload(String ... args) {
        super(args);
        this.addModule(modGraph);
        this.add(argDeclTruncate);
        this.add(argDeclReplace);
    }

    @Override
    protected String getCommandName() {
        return Lib.className(this);
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " <SPEC> [--graph IRI] file ...";
    }

    @Override
    protected void processModulesAndArgs() {
        if (this.getNumPositional() == 0) {
            this.cmdError("Need filenames of RDF data to load", true);
        }
    }

    @Override
    protected void execCmd(List<String> args) {
        if (this.contains(argDeclTruncate)) {
            this.getStore().getTableFormatter().truncate();
        }
        for (String x : args) {
            this.loadOne(x, this.contains(argDeclReplace));
        }
        StoreBaseHSQL.close(this.getStore());
    }

    private void loadOne(String filename, boolean replace) {
        boolean showProgress;
        Graph monitorGraph;
        PrefixMapping pmap;
        Model model = null;
        Dataset dataset = null;
        Lang lang = RDFLanguages.filenameToLang(filename);
        if (lang == null) {
            throw new CmdException("Data syntax not recognized: " + filename);
        }
        if (modGraph.getGraphName() != null) {
            pmap = model = modGraph.getModel(this.getStore());
        } else {
            dataset = SDBFactory.connectDataset(this.getStore());
            pmap = dataset.asDatasetGraph().getDefaultGraph().getPrefixMapping();
        }
        Graph graph = monitorGraph = model == null ? null : model.getGraph();
        if (replace) {
            if (model != null) {
                model.removeAll();
            } else {
                dataset.asDatasetGraph().clear();
            }
        }
        boolean bl = showProgress = this.isVerbose() || this.getModTime().timingEnabled();
        if (showProgress) {
            output.print("Start load: %s", filename);
        }
        StreamRDF stream = this.streamToStore(pmap, this.getStore());
        if (modGraph.getGraphName() != null) {
            Node gn = NodeFactory.createURI(modGraph.getGraphName());
            stream = StreamRDFLib.extendTriplesToQuads(gn, stream);
        }
        ProgressMonitor progress = null;
        if (showProgress) {
            progress = new ProgressMonitor(filename, 100000L, 10, output);
            stream = new ProgressStreamRDF(stream, progress);
        }
        if (progress != null) {
            progress.start();
        }
        RDFDataMgr.parse(stream, filename, lang);
        if (progress != null) {
            progress.finish();
            progress.finishMessage();
        }
    }

    private StreamRDF streamToStore(final PrefixMapping pmap, Store store) {
        final StoreLoaderPlus sl = (StoreLoaderPlus)store.getLoader();
        return new StreamRDF(){

            @Override
            public void start() {
                sl.startBulkUpdate();
            }

            @Override
            public void triple(Triple triple) {
                sl.addTriple(triple);
            }

            @Override
            public void quad(Quad quad) {
                sl.addQuad(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
            }

            @Override
            public void base(String base) {
            }

            @Override
            public void prefix(String prefix, String iri2) {
                pmap.setNsPrefix(prefix, iri2);
            }

            @Override
            public void finish() {
                sl.finishBulkUpdate();
            }
        };
    }
}

