/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.dao.jena;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.beans.PermissionSet;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.dao.jena.JenaBaseDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.UserAccountsDaoJena;
import edu.cornell.mannlib.vitro.webapp.dao.jena.WebappDaoFactoryJena;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UserAccountsDaoJenaTest
extends AbstractTestClass {
    private static final Set<String> EMPTY = Collections.emptySet();
    private static final String N3_DATA_FILENAME = "resources/UserAccountsDaoJenaTest.n3";
    private static final String NS_MINE = "http://vivo.mydomain.edu/individual/";
    private static final String URI_USER1 = "http://vivo.mydomain.edu/individual/user01";
    private static final String URI_NO_SUCH_USER = "http://vivo.mydomain.edu/individual/bogusUser";
    private static final String EMAIL_USER1 = "email@able.edu";
    private static final String EMAIL_NO_SUCH_USER = "http://vivo.mydomain.edu/individual/bogus@email.com";
    private static final String URI_ROLE1 = "http://vivo.mydomain.edu/individual/role1";
    private static final String URI_ROLE2 = "http://vivo.mydomain.edu/individual/role2";
    private static final String URI_ROLE3 = "http://vivo.mydomain.edu/individual/role3";
    private static final String URI_PROFILE1 = "http://vivo.mydomain.edu/individual/profile1";
    private static final String URI_PROFILE2 = "http://vivo.mydomain.edu/individual/profile2";
    private OntModel ontModel;
    private WebappDaoFactoryJena wadf;
    private UserAccountsDaoJena dao;
    private UserAccount user1;
    private UserAccount userNew;
    private UserAccount userA;
    private UserAccount userB;
    private UserAccount userC;

    @Before
    public void setup() throws IOException {
        InputStream stream = UserAccountsDaoJenaTest.class.getResourceAsStream(N3_DATA_FILENAME);
        Model model = ModelFactory.createDefaultModel();
        model.read(stream, null, "N3");
        stream.close();
        this.ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM, (Model)model);
        this.ontModel.prepare();
        this.wadf = new WebappDaoFactoryJena(this.ontModel);
        this.dao = new UserAccountsDaoJena(this.wadf);
    }

    @Before
    public void createUserAccountValues() {
        this.user1 = this.userAccount(URI_USER1, EMAIL_USER1, "Zack", "Roberts", "garbage", "", 0L, false, 5, 12345678L, UserAccount.Status.ACTIVE, "user1", false, this.collection(URI_ROLE1), false, EMPTY);
        this.userNew = this.userAccount("", "email@here", "Joe", "Blow", "XXXX", "YYYY", 0L, false, 1, 0L, UserAccount.Status.ACTIVE, "jblow", false, EMPTY, false, EMPTY);
        this.userA = this.userAccount("", "aahern@here", "Alf", "Ahern", "XXXX", "YYYY", 0L, false, 1, 0L, UserAccount.Status.ACTIVE, "aahern", false, EMPTY, false, this.collection(URI_PROFILE1));
        this.userB = this.userAccount("", "email@here", "Betty", "Boop", "XXXX", "YYYY", 0L, false, 1, 0L, UserAccount.Status.ACTIVE, "bboop", false, EMPTY, false, this.collection(URI_PROFILE1, URI_PROFILE2));
        this.userC = this.userAccount("", "ccallas@here", "Charlie", "Callas", "XXXX", "YYYY", 0L, false, 1, 0L, UserAccount.Status.ACTIVE, "ccallas", false, EMPTY, false, this.collection(URI_PROFILE2));
    }

    @Test
    public void getUserAccountByUriSuccess() {
        UserAccount u = this.dao.getUserAccountByUri(URI_USER1);
        this.assertEqualAccounts(this.user1, u);
    }

    @Test
    public void getUserAccountByUriNull() {
        UserAccount u = this.dao.getUserAccountByUri(null);
        Assert.assertNull((String)"null result", (Object)u);
    }

    @Test
    public void getUserAccountByUriNotFound() {
        UserAccount u = this.dao.getUserAccountByUri("bogusUri");
        Assert.assertNull((String)"null result", (Object)u);
    }

    @Test
    public void getUserAccountByUriWrongType() {
        UserAccount u = this.dao.getUserAccountByUri(URI_ROLE1);
        Assert.assertNull((String)"null result", (Object)u);
    }

    @Test
    public void getUserAccountByEmailSuccess() {
        UserAccount u = this.dao.getUserAccountByEmail(EMAIL_USER1);
        Assert.assertEquals((String)"uri", (Object)URI_USER1, (Object)u.getUri());
    }

    @Test
    public void getUserAccountByEmailNull() {
        UserAccount u = this.dao.getUserAccountByEmail(null);
        Assert.assertEquals((String)"uri", null, (Object)u);
    }

    @Test
    public void getUserAccountByEmailNotFound() {
        UserAccount u = this.dao.getUserAccountByEmail(EMAIL_NO_SUCH_USER);
        Assert.assertEquals((String)"uri", null, (Object)u);
    }

    @Test
    public void insertUserAccountSuccess() {
        UserAccount raw = this.userAccount(this.userNew);
        String uri = this.dao.insertUserAccount(raw);
        UserAccount processed = this.dao.getUserAccountByUri(uri);
        this.assertEqualAccounts(raw, processed);
    }

    @Test(expected=NullPointerException.class)
    public void insertUserAccountNullUserAccount() {
        this.dao.insertUserAccount(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void insertUserAccountUriIsNotEmpty() {
        UserAccount in = new UserAccount();
        in.setUri("http://vivo.mydomain.edu/individual/XXXXXX");
        this.dao.insertUserAccount(in);
    }

    @Test
    public void updateUserAccountSuccess() {
        UserAccount orig = this.userAccount(URI_USER1, "updatedEmail@able.edu", "Ezekiel", "Roberts", "differentHash", "oldHash", 1L, false, 43, 1020304050607080L, UserAccount.Status.ACTIVE, "updatedUser1", false, this.collection(URI_ROLE1, URI_ROLE3), false, EMPTY);
        this.dao.updateUserAccount(orig);
        UserAccount updated = this.dao.getUserAccountByUri(URI_USER1);
        this.assertEqualAccounts(orig, updated);
    }

    @Test(expected=NullPointerException.class)
    public void updateUserAccountNullUserAccount() {
        this.dao.updateUserAccount(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void updateUserAccountDoesNotExist() {
        UserAccount up = new UserAccount();
        up.setUri("http://vivo.mydomain.edu/individual/XXXXXX");
        this.dao.updateUserAccount(up);
    }

    @Test
    public void deleteUserAccountSuccess() {
        this.dao.deleteUserAccount(URI_USER1);
        StmtIterator stmts = this.ontModel.listStatements(this.ontModel.getResource(URI_USER1), null, (RDFNode)null);
        if (stmts.hasNext()) {
            String message = "Expecting no statements to remain in the model, but found:\n";
            while (stmts.hasNext()) {
                message = message + "   " + this.formatStatement((Statement)stmts.next()) + "\n";
            }
            Assert.fail((String)message);
        }
    }

    @Test
    public void deleteUserAccountNullUri() {
        this.dao.deleteUserAccount(null);
    }

    @Test
    public void deleteUserAccountDoesNotExist() {
        this.dao.deleteUserAccount(URI_NO_SUCH_USER);
    }

    @Test
    public void insertUserAccountWithProxies() {
        this.userNew.setProxiedIndividualUris(this.collection("http://vivo.mydomain.edu/individual/userNewProxyOne", "http://vivo.mydomain.edu/individual/userNewProxyTwo"));
        String userUri = this.dao.insertUserAccount(this.userNew);
        UserAccount inserted = this.dao.getUserAccountByUri(userUri);
        this.assertEqualAccounts(this.userNew, inserted);
    }

    @Test
    public void updateUserAccountWithProxies() {
        UserAccount beforeAccount = this.dao.getUserAccountByUri(URI_USER1);
        this.user1.setProxiedIndividualUris(this.collection("http://vivo.mydomain.edu/individual/newProxyForUser1"));
        this.dao.updateUserAccount(this.user1);
        UserAccount updated = this.dao.getUserAccountByUri(URI_USER1);
        this.assertEqualAccounts(this.user1, updated);
    }

    @Test
    public void getProxyEditorsFirst() {
        String profileOne = "http://vivo.mydomain.edu/individual/userNewProxyOne";
        String profileTwo = "http://vivo.mydomain.edu/individual/userNewProxyTwo";
        this.userNew.setProxiedIndividualUris(this.collection(profileOne, profileTwo));
        String userUri = this.dao.insertUserAccount(this.userNew);
        UserAccount user = this.dao.getUserAccountByUri(userUri);
        this.assertExpectedAccountUris("proxy for profile one", Collections.singleton(user), this.dao.getUserAccountsWhoProxyForPage(profileOne));
    }

    @Test
    public void getProxyEditorsSecond() {
        String profileOne = "http://vivo.mydomain.edu/individual/userNewProxyOne";
        String profileTwo = "http://vivo.mydomain.edu/individual/userNewProxyTwo";
        this.userNew.setProxiedIndividualUris(this.collection(profileOne, profileTwo));
        String userUri = this.dao.insertUserAccount(this.userNew);
        UserAccount user = this.dao.getUserAccountByUri(userUri);
        this.assertExpectedAccountUris("proxy for profile two", Collections.singleton(user), this.dao.getUserAccountsWhoProxyForPage(profileTwo));
    }

    @Test
    public void getProxyEditorsBogus() {
        String profileOne = "http://vivo.mydomain.edu/individual/userNewProxyOne";
        String profileTwo = "http://vivo.mydomain.edu/individual/userNewProxyTwo";
        String bogusProfile = "http://vivo.mydomain.edu/individual/bogus";
        this.userNew.setProxiedIndividualUris(this.collection(profileOne, profileTwo));
        this.dao.insertUserAccount(this.userNew);
        this.assertExpectedAccountUris("proxy for bogus profile", Collections.emptySet(), this.dao.getUserAccountsWhoProxyForPage(bogusProfile));
    }

    @Test
    public void setProxyEditorsOnProfile() {
        String uriA = this.dao.insertUserAccount(this.userA);
        String uriB = this.dao.insertUserAccount(this.userB);
        String uriC = this.dao.insertUserAccount(this.userC);
        this.dao.setProxyAccountsOnProfile(URI_PROFILE1, this.collection(uriB, uriC));
        this.assertExpectedProxies("userA", this.collection(new String[0]), this.dao.getUserAccountByUri(uriA).getProxiedIndividualUris());
        this.assertExpectedProxies("userB", this.collection(URI_PROFILE1, URI_PROFILE2), this.dao.getUserAccountByUri(uriB).getProxiedIndividualUris());
        this.assertExpectedProxies("userC", this.collection(URI_PROFILE1, URI_PROFILE2), this.dao.getUserAccountByUri(uriC).getProxiedIndividualUris());
    }

    @Test
    public void getPermissionSetByUriSuccess() {
        PermissionSet ps = this.dao.getPermissionSetByUri(URI_ROLE1);
        Assert.assertEquals((String)"uri", (Object)URI_ROLE1, (Object)ps.getUri());
        Assert.assertEquals((String)"label", (Object)"Role 1", (Object)ps.getLabel());
        Assert.assertEquals((String)"permissionUris", Collections.singleton("http://vivo.mydomain.edu/individual/permissionA"), (Object)ps.getPermissionUris());
    }

    @Test
    public void getPermissionSetByUriNull() {
        PermissionSet ps = this.dao.getPermissionSetByUri(null);
        Assert.assertNull((String)"null result", (Object)ps);
    }

    @Test
    public void getPermissionSetByUriNotFound() {
        PermissionSet ps = this.dao.getPermissionSetByUri("bogusUri");
        Assert.assertNull((String)"null result", (Object)ps);
    }

    @Test
    public void getPermissionSetByUriWrongType() {
        PermissionSet ps = this.dao.getPermissionSetByUri(URI_USER1);
        Assert.assertNull((String)"null result", (Object)ps);
    }

    @Test
    public void getAllPermissionSets() {
        UserAccountsDaoJenaTest.setLoggerLevel(JenaBaseDao.class, Level.DEBUG);
        HashSet<PermissionSet> expected = new HashSet<PermissionSet>();
        PermissionSet ps1 = new PermissionSet();
        ps1.setUri(URI_ROLE1);
        ps1.setLabel("Role 1");
        ps1.setPermissionUris(Collections.singleton("http://vivo.mydomain.edu/individual/permissionA"));
        expected.add(ps1);
        PermissionSet ps2 = new PermissionSet();
        ps2.setUri(URI_ROLE2);
        ps2.setLabel("Role 2");
        ps2.setForNewUsers(Boolean.valueOf(true));
        expected.add(ps2);
        PermissionSet ps3 = new PermissionSet();
        ps3.setUri(URI_ROLE3);
        ps3.setLabel("Role 3");
        ps3.setForPublic(Boolean.valueOf(true));
        expected.add(ps3);
        this.assertCorrectPermissionSets(expected, this.dao.getAllPermissionSets());
    }

    private Collection<String> collection(String ... args) {
        return Arrays.asList(args);
    }

    private UserAccount userAccount(String uri, String emailAddress, String firstName, String lastName, String md5Password, String oldPassword, long passwordLinkExpires, boolean passwordChangeRequired, int loginCount, long lastLoginTime, UserAccount.Status status, String externalAuthId, boolean externalAuthOnly, Collection<String> permissionSetUris, boolean rootUser, Collection<String> proxiedIndividualUris) {
        UserAccount ua = new UserAccount();
        ua.setUri(uri);
        ua.setEmailAddress(emailAddress);
        ua.setFirstName(firstName);
        ua.setLastName(lastName);
        ua.setMd5Password(md5Password);
        ua.setOldPassword(oldPassword);
        ua.setPasswordLinkExpires(passwordLinkExpires);
        ua.setPasswordChangeRequired(Boolean.valueOf(passwordChangeRequired));
        ua.setLoginCount(loginCount);
        ua.setLastLoginTime(lastLoginTime);
        ua.setStatus(status);
        ua.setExternalAuthId(externalAuthId);
        ua.setExternalAuthOnly(Boolean.valueOf(externalAuthOnly));
        ua.setPermissionSetUris(permissionSetUris);
        ua.setRootUser(rootUser);
        ua.setProxiedIndividualUris(proxiedIndividualUris);
        return ua;
    }

    private UserAccount userAccount(UserAccount in) {
        UserAccount out = new UserAccount();
        out.setUri(in.getUri());
        out.setEmailAddress(in.getEmailAddress());
        out.setFirstName(in.getFirstName());
        out.setLastName(in.getLastName());
        out.setMd5Password(in.getMd5Password());
        out.setOldPassword(in.getOldPassword());
        out.setPasswordLinkExpires(in.getPasswordLinkExpires());
        out.setPasswordChangeRequired(Boolean.valueOf(in.isPasswordChangeRequired()));
        out.setLoginCount(in.getLoginCount());
        out.setLastLoginTime(in.getLastLoginTime());
        out.setStatus(in.getStatus());
        out.setExternalAuthId(in.getExternalAuthId());
        out.setExternalAuthOnly(Boolean.valueOf(in.isExternalAuthOnly()));
        out.setPermissionSetUris((Collection)in.getPermissionSetUris());
        out.setRootUser(in.isRootUser());
        out.setProxiedIndividualUris((Collection)in.getProxiedIndividualUris());
        return out;
    }

    private void assertEqualAccounts(UserAccount e, UserAccount a) {
        if (!e.getUri().equals("")) {
            Assert.assertEquals((String)"uri", (Object)e.getUri(), (Object)a.getUri());
        }
        Assert.assertEquals((String)"email", (Object)e.getEmailAddress(), (Object)a.getEmailAddress());
        Assert.assertEquals((String)"first name", (Object)e.getFirstName(), (Object)a.getFirstName());
        Assert.assertEquals((String)"last name", (Object)e.getLastName(), (Object)a.getLastName());
        Assert.assertEquals((String)"password", (Object)e.getMd5Password(), (Object)a.getMd5Password());
        Assert.assertEquals((String)"old password", (Object)e.getOldPassword(), (Object)a.getOldPassword());
        Assert.assertEquals((String)"link expires", (long)e.getPasswordLinkExpires(), (long)a.getPasswordLinkExpires());
        Assert.assertEquals((String)"password change", (Object)e.isPasswordChangeRequired(), (Object)a.isPasswordChangeRequired());
        Assert.assertEquals((String)"login count", (long)e.getLoginCount(), (long)a.getLoginCount());
        Assert.assertEquals((String)"last login", (long)e.getLastLoginTime(), (long)a.getLastLoginTime());
        Assert.assertEquals((String)"status", (Object)e.getStatus(), (Object)a.getStatus());
        Assert.assertEquals((String)"external ID", (Object)e.getExternalAuthId(), (Object)a.getExternalAuthId());
        Assert.assertEquals((String)"external only", (Object)e.isExternalAuthOnly(), (Object)a.isExternalAuthOnly());
        Assert.assertEquals((String)"permission sets", (Object)e.getPermissionSetUris(), (Object)a.getPermissionSetUris());
        Assert.assertEquals((String)"root user", (Object)e.isRootUser(), (Object)a.isRootUser());
        Assert.assertEquals((String)"proxied URIs", (Object)e.getProxiedIndividualUris(), (Object)a.getProxiedIndividualUris());
    }

    private void assertCorrectPermissionSets(Set<PermissionSet> expected, Collection<PermissionSet> actual) {
        HashSet<Map<String, Object>> expectedMaps = new HashSet<Map<String, Object>>();
        for (PermissionSet ps : expected) {
            expectedMaps.add(this.buildMapFromPermissionSet(ps));
        }
        HashSet<Map<String, Object>> actualMaps = new HashSet<Map<String, Object>>();
        for (PermissionSet ps : actual) {
            actualMaps.add(this.buildMapFromPermissionSet(ps));
        }
        Assert.assertEquals((String)"all permission sets", expectedMaps, actualMaps);
    }

    private Map<String, Object> buildMapFromPermissionSet(PermissionSet ps) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("uri", ps.getUri());
        map.put("label", ps.getLabel());
        map.put("permissions", ps.getPermissionUris());
        map.put("forNewUsers", ps.isForNewUsers());
        map.put("forPublic", ps.isForPublic());
        return map;
    }

    private void assertExpectedAccountUris(String label, Set<UserAccount> expectedUserAccounts, Collection<UserAccount> actualUserAccounts) {
        HashSet<String> expectedUris = new HashSet<String>();
        for (UserAccount ua : expectedUserAccounts) {
            expectedUris.add(ua.getUri());
        }
        HashSet<String> actualUris = new HashSet<String>();
        for (UserAccount ua : actualUserAccounts) {
            actualUris.add(ua.getUri());
        }
        this.assertEqualSets(label, expectedUris, actualUris);
    }

    private void assertExpectedProxies(String label, Collection<String> expected, Set<String> actual) {
        HashSet<String> expectedSet = new HashSet<String>(expected);
        this.assertEqualSets(label, expectedSet, actual);
    }

    private void dumpModelStatements() {
        StmtIterator stmts = this.ontModel.listStatements();
        while (stmts.hasNext()) {
            Statement statement = (Statement)stmts.next();
        }
    }

    private String formatStatement(Statement stmt) {
        return stmt.getSubject().getURI() + " ==> " + stmt.getPredicate().getURI() + " ==> " + stmt.getObject().toString();
    }
}

