/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.documentBuilding;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.IndividualImpl;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ContextModelAccess;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchInputDocument;
import edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchInputField;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.model.RDFServiceModel;
import edu.cornell.mannlib.vitro.webapp.searchindex.documentBuilding.ThumbnailImageURL;
import java.io.InputStream;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.impl.RDFDefaultErrorHandler;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.modelaccess.ContextModelAccessStub;
import stubs.edu.cornell.mannlib.vitro.webapp.modules.ApplicationStub;
import stubs.edu.cornell.mannlib.vitro.webapp.modules.searchEngine.SearchEngineStub;
import stubs.javax.servlet.ServletContextStub;

public class ThumbnailImageURLTest
extends AbstractTestClass {
    ContextModelAccessStub contextModels;
    String personsURI = "http://vivo.cornell.edu/individual/individual8803";

    @Before
    public void setUp() throws Exception {
        ThumbnailImageURLTest.setLoggerLevel(RDFDefaultErrorHandler.class, Level.OFF);
        ApplicationStub.setup(new ServletContextStub(), new SearchEngineStub());
        Model model = ModelFactory.createDefaultModel();
        InputStream in = ThumbnailImageURLTest.class.getResourceAsStream("testPerson.n3");
        model.read(in, "", "N3");
        this.contextModels = new ContextModelAccessStub();
        this.contextModels.setRDFService(ModelAccess.WhichService.CONTENT, (RDFService)new RDFServiceModel(model));
    }

    @Test
    public void testThumbnailFieldCreatedInSearchDoc() {
        SearchInputDocument doc = ApplicationUtils.instance().getSearchEngine().createInputDocument();
        ThumbnailImageURL testMe = new ThumbnailImageURL();
        testMe.setContextModels((ContextModelAccess)this.contextModels);
        IndividualImpl ind = new IndividualImpl();
        ind.setURI(this.personsURI);
        testMe.modifyDocument((Individual)ind, doc);
        SearchInputField thumbnailField = doc.getField("THUMBNAIL_URL");
        Assert.assertNotNull((Object)thumbnailField);
        Assert.assertNotNull((Object)thumbnailField.getValues());
        Assert.assertEquals((long)1L, (long)thumbnailField.getValues().size());
        Assert.assertEquals((Object)"http://vivo.cornell.edu/individual/n54945", (Object)thumbnailField.getFirstValue());
    }
}

