/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.indexing;

import edu.cornell.mannlib.vitro.webapp.modelaccess.ContextModelAccess;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.jena.model.RDFServiceModel;
import edu.cornell.mannlib.vitro.webapp.searchindex.indexing.AdditionalURIsForObjectProperties;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDFS;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import stubs.edu.cornell.mannlib.vitro.webapp.modelaccess.ContextModelAccessStub;

public class AdditionalURIsForObjectPropertiesTest {
    Model model;
    RDFService rdfService;
    AdditionalURIsForObjectProperties aufop;
    String testNS = "http://example.com/test#";
    String n3 = "@prefix owl: <http://www.w3.org/2002/07/owl#> .\n@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>  . \n@prefix rdfs:  <http://www.w3.org/2000/01/rdf-schema#> . \n@prefix test:  <" + this.testNS + "> . \n" + "\n" + "test:bob rdfs:label \"Mr Bob\" .  \n" + "test:bob test:hatsize \"8 1/2 inches\" .  \n" + "test:bob test:likes test:icecream .  \n" + "test:bob test:likes test:onions .  \n" + "test:bob test:likes test:cheese .  \n" + "test:bob a test:Person .  \n" + "test:bob a owl:Thing .  \n" + "test:bob test:likes [ rdfs:label \"this is a blank node\" ] . ";
    String n3ForNIHVIVO_2902 = "@prefix dc:      <http://purl.org/dc/elements/1.1/> . \n@prefix pvs:     <http://vivoweb.org/ontology/provenance-support#> . \n@prefix geo:     <http://aims.fao.org/aos/geopolitical.owl#> . \n@prefix foaf:    <http://xmlns.com/foaf/0.1/> . \n@prefix scires:  <http://vivoweb.org/ontology/scientific-research#>  . \n@prefix scripps:  <http://vivo.scripps.edu/> . \n@prefix dcterms:  <http://purl.org/dc/terms/> . \n@prefix rdfs:    <http://www.w3.org/2000/01/rdf-schema#> . \n@prefix swrl:    <http://www.w3.org/2003/11/swrl#> . \n@prefix vitro:   <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#>. \n@prefix event:   <http://purl.org/NET/c4dm/event.owl#> . \n@prefix bibo:    <http://purl.org/ontology/bibo/> . \n@prefix xsd:     <http://www.w3.org/2001/XMLSchema#> . \n@prefix owl:     <http://www.w3.org/2002/07/owl#> . \n@prefix swrlb:   <http://www.w3.org/2003/11/swrlb#> . \n@prefix rdf:     <http://www.w3.org/1999/02/22-rdf-syntax-ns#> . \n@prefix core:    <http://vivoweb.org/ontology/core#> . \n@prefix skos:    <http://www.w3.org/2004/02/skos/core#> . \n@prefix vivo:    <http://vivo.library.cornell.edu/ns/0.1#> . \n@prefix dcelem:  <http://purl.org/dc/elements/1.1/> . \n@prefix ero:     <http://purl.obolibrary.org/obo/> . \n \n<http://caruso-laptop.mannlib.cornell.edu:8090/vivo/individual/n2241> \n      a       core:FacultyMember , foaf:Person , owl:Thing , foaf:Agent ; \n      rdfs:label \"Faculty, Jane\" ; \n      vitro:modTime \"2011-07-15T15:08:35\"^^xsd:dateTime ; \n      vitro:mostSpecificType \n              core:FacultyMember ; \n      core:hasResearchArea \n              <http://caruso-laptop.mannlib.cornell.edu:8090/vivo/individual/n7416> ; \n      core:mailingAddress <http://caruso-laptop.mannlib.cornell.edu:8090/vivo/individual/n5993> ; \n      foaf:firstName \"Jane\"^^xsd:string ; \n      foaf:lastName \"Faculty\"^^xsd:string . ";

    @Before
    public void setUp() throws Exception {
        this.model = ModelFactory.createDefaultModel();
        this.model.read((Reader)new StringReader(this.n3), null, "N3");
        this.rdfService = new RDFServiceModel(this.model);
        ContextModelAccessStub models = new ContextModelAccessStub();
        models.setRDFService(ModelAccess.WhichService.CONTENT, this.rdfService);
        this.aufop = new AdditionalURIsForObjectProperties();
        this.aufop.setContextModels((ContextModelAccess)models);
    }

    @Test
    public void testChangeOfRdfsLabel() {
        List uris = this.aufop.findAdditionalURIsToIndex(ResourceFactory.createStatement((Resource)ResourceFactory.createResource((String)(this.testNS + "bob")), (Property)RDFS.label, (RDFNode)ResourceFactory.createPlainLiteral((String)"Some new label for bob")));
        Assert.assertNotNull((Object)uris);
        Assert.assertTrue((String)"uris was empty", (uris.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"uris didn't not contain test:onions", (boolean)uris.contains(this.testNS + "onions"));
        Assert.assertTrue((String)"uris didn't not contain test:cheese", (boolean)uris.contains(this.testNS + "cheese"));
        Assert.assertTrue((String)"uris didn't not contain test:icecream", (boolean)uris.contains(this.testNS + "icecream"));
        Assert.assertTrue((String)"uris contained test:Person", (!uris.contains(this.testNS + "Person") ? 1 : 0) != 0);
        Assert.assertTrue((String)"uris contained owl:Thing", (!uris.contains(OWL.Thing.getURI()) ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)uris.size());
    }

    @Test
    public void testChangeOfObjPropStmt() {
        List uris = this.aufop.findAdditionalURIsToIndex(ResourceFactory.createStatement((Resource)ResourceFactory.createResource((String)(this.testNS + "bob")), (Property)ResourceFactory.createProperty((String)(this.testNS + "likes")), (RDFNode)ResourceFactory.createResource((String)(this.testNS + "cheese"))));
        Assert.assertNotNull((Object)uris);
        Assert.assertTrue((String)"uris was empty", (uris.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"uris didn't not contain test:cheese", (boolean)uris.contains(this.testNS + "cheese"));
        Assert.assertTrue((String)"uris contained test:Person", (!uris.contains(this.testNS + "Person") ? 1 : 0) != 0);
        Assert.assertTrue((String)"uris contained owl:Thing", (!uris.contains(OWL.Thing.getURI()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"uris contained test:onions", (!uris.contains(this.testNS + "onions") ? 1 : 0) != 0);
        Assert.assertTrue((String)"uris contained test:icecream", (!uris.contains(this.testNS + "icecream") ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)uris.size());
    }

    @Test
    public void testOfDataPropChange() {
        List uris = this.aufop.findAdditionalURIsToIndex(ResourceFactory.createStatement((Resource)ResourceFactory.createResource((String)(this.testNS + "bob")), (Property)ResourceFactory.createProperty((String)(this.testNS + "hatsize")), (RDFNode)ResourceFactory.createPlainLiteral((String)"Some new hat size for bob")));
        Assert.assertNotNull((Object)uris);
        Assert.assertTrue((String)"uris was not empty", (uris.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNIHVIVO_2902() {
        Model model = ModelFactory.createDefaultModel();
        model.read((Reader)new StringReader(this.n3ForNIHVIVO_2902), null, "N3");
        ContextModelAccessStub models = new ContextModelAccessStub();
        models.setRDFService(ModelAccess.WhichService.CONTENT, (RDFService)new RDFServiceModel(model));
        this.aufop.setContextModels((ContextModelAccess)models);
        List uris = this.aufop.findAdditionalURIsToIndex(ResourceFactory.createStatement((Resource)ResourceFactory.createResource((String)"http://caruso-laptop.mannlib.cornell.edu:8090/vivo/individual/n2241"), (Property)ResourceFactory.createProperty((String)"http://vivoweb.org/ontology/core#hasResearchArea"), (RDFNode)ResourceFactory.createResource((String)"http://caruso-laptop.mannlib.cornell.edu:8090/vivo/individual/n7416")));
        Assert.assertNotNull((Object)uris);
        Assert.assertTrue((String)"uris was empty", (uris.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"NIHVIVO-2902 regression, research area is not getting reindexed", (boolean)uris.contains("http://caruso-laptop.mannlib.cornell.edu:8090/vivo/individual/n7416"));
    }
}

