/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner;

import edu.cornell.mannlib.vitro.testing.AbstractTestClass;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.QueryHolder;
import org.junit.Assert;
import org.junit.Test;

public class QueryHolderTest
extends AbstractTestClass {
    private static final String SOME_URI = "http://some.uri/";
    private static final String SOME_LITERAL = "abracadabra";
    private static final String FIND_ONCE = "SELECT ?s ?p WHERE { ?s ?p ?bindMe }";
    private static final String URI_BOUND_ONCE = "SELECT ?s ?p WHERE { ?s ?p <http://some.uri/> }";
    private static final String LITERAL_BOUND_ONCE = "SELECT ?s ?p WHERE { ?s ?p \"abracadabra\" }";
    private static final String FIND_TWICE = "CONSTRUCT { ?s ?p ?find_twice } WHERE { ?s ?p ?find_twice }";
    private static final String URI_BOUND_TWICE = "CONSTRUCT { ?s ?p <http://some.uri/> } WHERE { ?s ?p <http://some.uri/> }";
    private static final String LITERAL_BOUND_TWICE = "CONSTRUCT { ?s ?p \"abracadabra\" } WHERE { ?s ?p \"abracadabra\" }";
    private static final String SQUEEZED = "CONSTRUCT {?s ?p ?squeeze} WHERE {?s ?p ?squeeze}";
    private static final String URI_BOUND_SQUEEZED = "CONSTRUCT {?s ?p <http://some.uri/>} WHERE {?s ?p <http://some.uri/>}";
    private static final String LITERAL_BOUND_SQUEEZED = "CONSTRUCT {?s ?p \"abracadabra\"} WHERE {?s ?p \"abracadabra\"}";
    private static final String FIND_IN_SELECT_CLAUSE = "SELECT ?s ?p ?bindMe WHERE { ?s ?p ?bindMe }";
    private static final String URI_BOUND_IN_SELECT_CLAUSE = "SELECT ?s ?p ?bindMe WHERE { ?s ?p <http://some.uri/> }";

    @Test
    public void hasVariable_findsOne() {
        Assert.assertTrue((boolean)new QueryHolder(FIND_ONCE).hasVariable("bindMe"));
    }

    @Test
    public void hasVariable_findsTwo() {
        Assert.assertTrue((boolean)new QueryHolder(FIND_TWICE).hasVariable("find_twice"));
    }

    @Test
    public void hasVariable_doesntFindOne() {
        Assert.assertFalse((boolean)new QueryHolder(FIND_TWICE).hasVariable("notThere"));
    }

    @Test
    public void hasVariable_notFooledByExtendedName() {
        Assert.assertFalse((boolean)new QueryHolder(FIND_ONCE).hasVariable("bind"));
    }

    @Test
    public void hasVariable_notFooledByPunctuation() {
        Assert.assertTrue((boolean)new QueryHolder(SQUEEZED).hasVariable("squeeze"));
    }

    @Test
    public void bindToUri_notFound_noComplaint() {
        this.bindToUri(FIND_ONCE, "notThere", SOME_URI).yields(FIND_ONCE);
    }

    @Test
    public void bindToUri_findsOne_bindsIt() {
        this.bindToUri(FIND_ONCE, "bindMe", SOME_URI).yields(URI_BOUND_ONCE);
    }

    @Test
    public void bindToUri_findsTwo_bindsBoth() {
        this.bindToUri(FIND_TWICE, "find_twice", SOME_URI).yields(URI_BOUND_TWICE);
    }

    @Test
    public void bindToUri_notFooledByExtendedName() {
        this.bindToUri(FIND_ONCE, "bind", SOME_URI).yields(FIND_ONCE);
    }

    @Test
    public void bindToUri_notFooledByPunctuation() {
        this.bindToUri(SQUEEZED, "squeeze", SOME_URI).yields(URI_BOUND_SQUEEZED);
    }

    @Test
    public void bindToPlainLiteral_notFound_noComplaint() {
        this.bindToLiteral(FIND_ONCE, "notThere", SOME_LITERAL).yields(FIND_ONCE);
    }

    @Test
    public void bindToPlainLiteral_findsOne_bindsIt() {
        this.bindToLiteral(FIND_ONCE, "bindMe", SOME_LITERAL).yields(LITERAL_BOUND_ONCE);
    }

    @Test
    public void bindToPlainLiteral_findsTwo_bindsBoth() {
        this.bindToLiteral(FIND_TWICE, "find_twice", SOME_LITERAL).yields(LITERAL_BOUND_TWICE);
    }

    @Test
    public void bindToPlainLiteral_notFooledByExtendedName() {
        this.bindToLiteral(FIND_ONCE, "bind", SOME_LITERAL).yields(FIND_ONCE);
    }

    @Test
    public void bindToPlainLiteral_notFooledByPunctuation() {
        this.bindToLiteral(SQUEEZED, "squeeze", SOME_LITERAL).yields(LITERAL_BOUND_SQUEEZED);
    }

    @Test
    public void variableInSelectClauseIsLeftAlone() {
        this.bindToUri(FIND_IN_SELECT_CLAUSE, "bindMe", SOME_URI).yields(URI_BOUND_IN_SELECT_CLAUSE);
    }

    private Yielder bindToUri(String query, String name, String uri) {
        QueryHolder holder = new QueryHolder(query);
        QueryHolder bound = holder.bindToUri(name, uri);
        return new Yielder(bound.getQueryString());
    }

    private Yielder bindToLiteral(String query, String name, String value) {
        QueryHolder holder = new QueryHolder(query);
        QueryHolder bound = holder.bindToPlainLiteral(name, value);
        return new Yielder(bound.getQueryString());
    }

    private class Yielder {
        private final String actual;

        public Yielder(String actual) {
            this.actual = actual;
        }

        void yields(String expected) {
            Assert.assertEquals((Object)expected, (Object)this.actual);
        }
    }
}

