/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vedit.tags;

import edu.cornell.mannlib.vedit.beans.DynamicField;
import edu.cornell.mannlib.vedit.beans.DynamicFieldRow;
import edu.cornell.mannlib.vedit.beans.FormObject;
import edu.cornell.mannlib.vedit.tags.EditTag;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.codec.binary.Base64;

public class DynamicFieldsTag
extends EditTag {
    private char PATH_SEP = File.separatorChar;
    public final String MARKUP_FILE_PATH = "templates" + this.PATH_SEP + "edit" + this.PATH_SEP + "specific" + this.PATH_SEP;
    private String name = null;
    private String type = null;
    private String usePage = null;
    private String preMarkup = null;
    private String templateMarkup = null;
    private String postMarkup = null;

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUsePage(String usePage) {
        this.usePage = usePage;
    }

    public void parseMarkup() throws JspException {
        try {
            int i;
            int preStart = -1;
            int templateStart = -1;
            int postStart = -1;
            FileInputStream fis = new FileInputStream(this.pageContext.getServletContext().getRealPath(new String()) + this.PATH_SEP + this.MARKUP_FILE_PATH + this.usePage);
            BufferedInputStream bis = new BufferedInputStream(fis);
            BufferedReader in = new BufferedReader(new InputStreamReader(bis));
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("");
            int lineIndex = 0;
            while (in.ready()) {
                ++lineIndex;
                String currentLine = in.readLine();
                if (currentLine != null && currentLine.indexOf("<!--") == 0 && currentLine.indexOf("@pre") > 0) {
                    preStart = lineIndex;
                } else if (currentLine != null && currentLine.indexOf("<!--") == 0 && currentLine.indexOf("@template") > 0) {
                    templateStart = lineIndex;
                } else if (currentLine != null && currentLine.indexOf("<!--") == 0 && currentLine.indexOf("@post") > 0) {
                    postStart = lineIndex;
                }
                lines.add(currentLine);
            }
            in.close();
            StringBuffer preMarkupB = new StringBuffer();
            StringBuffer postMarkupB = new StringBuffer();
            StringBuffer templateMarkupB = new StringBuffer();
            if (templateStart > preStart && preStart > 0) {
                for (i = preStart + 1; i < templateStart; ++i) {
                    preMarkupB.append((String)lines.get(i)).append("\n");
                }
            } else {
                System.out.println("DynamicFieldsTag could not find @pre markup in " + this.MARKUP_FILE_PATH + this.usePage);
                throw new JspException("DynamicFieldsTag could not parse @pre markup section");
            }
            this.preMarkup = preMarkupB.toString();
            if (postStart > templateStart && templateStart > 0) {
                for (i = templateStart + 1; i < postStart; ++i) {
                    templateMarkupB.append((String)lines.get(i)).append("\n");
                }
            } else {
                System.out.println("DynamicFieldsTag could not find @template markup in " + this.MARKUP_FILE_PATH + this.usePage);
                throw new JspException("DynamicFieldsTag could not parse @template markup section");
            }
            this.templateMarkup = templateMarkupB.toString();
            if (postStart > 0) {
                for (i = postStart + 1; i < lines.size(); ++i) {
                    postMarkupB.append((String)lines.get(i)).append("\n");
                }
            } else {
                System.out.println("DynamicFieldsTag could not find @post markup in " + this.MARKUP_FILE_PATH + this.usePage);
                throw new JspException("DynamicFieldsTag could not parse @post markup section");
            }
            this.postMarkup = postMarkupB.toString();
        }
        catch (FileNotFoundException e) {
            System.out.println("DynamicFieldsTag could not find markup file at " + this.pageContext.getServletContext().getRealPath(new String()) + "\\" + this.MARKUP_FILE_PATH + this.usePage);
        }
        catch (IOException ioe) {
            System.out.println("DynamicFieldsTag encountered IOException reading " + this.pageContext.getServletContext().getRealPath(new String()) + "\\" + this.MARKUP_FILE_PATH + this.usePage);
        }
    }

    public String strReplace(String input, String pattern, String replacement) {
        String[] piece = input.split(pattern);
        StringBuffer output = new StringBuffer();
        for (int i = 0; i < piece.length; ++i) {
            output.append(piece[i]);
            if (i >= piece.length - 1) continue;
            output.append(replacement);
        }
        return output.toString();
    }

    @Override
    public int doEndTag() throws JspException {
        try {
            this.parseMarkup();
            JspWriter out = this.pageContext.getOut();
            Object values = null;
            try {
                FormObject foo = this.getFormObject();
                List<DynamicField> dynfs = foo.getDynamicFields();
                Iterator<DynamicField> dynIt = dynfs.iterator();
                int i = 9899;
                while (dynIt.hasNext()) {
                    DynamicField dynf = dynIt.next();
                    StringBuffer genTaName = new StringBuffer().append("_").append(dynf.getTable()).append("_");
                    genTaName.append("-1").append("_");
                    for (String key : dynf.getRowTemplate().getParameterMap().keySet()) {
                        String value = (String)dynf.getRowTemplate().getParameterMap().get(key);
                        byte[] valueInBase64 = Base64.encodeBase64((byte[])value.getBytes());
                        genTaName.append(key).append(":").append(new String(valueInBase64)).append(";");
                    }
                    String preWithVars = new String(this.preMarkup);
                    preWithVars = this.strReplace(preWithVars, this.type + "NN", Integer.toString(i));
                    preWithVars = this.strReplace(preWithVars, "\\$genTaName", genTaName.toString());
                    preWithVars = this.strReplace(preWithVars, "\\$fieldName", dynf.getName());
                    out.print(preWithVars);
                    Iterator<DynamicFieldRow> rowIt = dynf.getRowList().iterator();
                    while (rowIt.hasNext()) {
                        ++i;
                        DynamicFieldRow row = rowIt.next();
                        if (row.getValue() == null) {
                            row.setValue("");
                        }
                        if (row.getValue().length() <= 0) continue;
                        StringBuffer taName = new StringBuffer().append("_").append(dynf.getTable()).append("_");
                        taName.append(row.getId()).append("_");
                        for (String key : row.getParameterMap().keySet()) {
                            String value = (String)row.getParameterMap().get(key);
                            byte[] valueInBase64 = Base64.encodeBase64((byte[])value.getBytes());
                            taName.append(key).append(":").append(new String(valueInBase64)).append(";");
                        }
                        if (row.getValue().length() <= 0) continue;
                        String templateWithVars = new String(this.templateMarkup);
                        templateWithVars = this.strReplace(templateWithVars, this.type + "NN", Integer.toString(i));
                        templateWithVars = this.strReplace(templateWithVars, "\\$taName", taName.toString());
                        templateWithVars = this.strReplace(templateWithVars, "\\$\\$", row.getValue());
                        out.print(templateWithVars);
                    }
                    out.print(this.postMarkup);
                }
                out.println("<!-- row template inserted by DynamicFieldsTag  -->");
                String hiddenTemplatePreMarkup = new String(this.preMarkup);
                hiddenTemplatePreMarkup = this.strReplace(hiddenTemplatePreMarkup, "display\\:none\\;", "");
                hiddenTemplatePreMarkup = this.strReplace(hiddenTemplatePreMarkup, "display\\:block\\;", "");
                hiddenTemplatePreMarkup = this.strReplace(hiddenTemplatePreMarkup, "display\\:inline\\;", "");
                hiddenTemplatePreMarkup = this.strReplace(hiddenTemplatePreMarkup, "style\\=\\\"", "style=\"display:none;");
                out.print(hiddenTemplatePreMarkup);
                String hiddenTemplateTemplateMarkup = new String(this.templateMarkup);
                hiddenTemplateTemplateMarkup = this.strReplace(hiddenTemplateTemplateMarkup, "\\$\\$", "");
                out.print(hiddenTemplateTemplateMarkup);
                out.print(this.postMarkup);
            }
            catch (Exception e) {
                System.out.println("DynamicFieldsTag could not get the form object");
            }
        }
        catch (Exception ex) {
            throw new JspException(ex.getMessage());
        }
        return 0;
    }
}

