/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.beans;

import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.vocabulary.XSD;

public class DataPropertyComparator
implements Comparator<Individual> {
    private static final Log log = LogFactory.getLog(DataPropertyComparator.class);
    private String dataPropertyUri = null;

    public DataPropertyComparator(String dataPropertyUri) {
        this.dataPropertyUri = dataPropertyUri;
    }

    @Override
    public int compare(Individual ind1, Individual ind2) {
        int result;
        DataPropertyStatement dps1 = ind1.getDataPropertyStatement(this.dataPropertyUri);
        DataPropertyStatement dps2 = ind2.getDataPropertyStatement(this.dataPropertyUri);
        if (dps1 == null) {
            result = dps2 == null ? 0 : 1;
        } else if (dps2 == null) {
            result = -1;
        } else {
            String datatype = dps1.getDatatypeURI();
            if (datatype == null) {
                datatype = dps2.getDatatypeURI();
            }
            if (datatype == null) {
                log.warn((Object)"Can't compare data property statements: no datatype specified.");
                datatype = XSD.xint.toString();
            }
            if (XSD.xint.toString().equals(datatype)) {
                int i1 = Integer.valueOf(dps1.getData());
                int i2 = Integer.valueOf(dps2.getData());
                result = Integer.valueOf(i1).compareTo(i2);
            } else if (XSD.xstring.toString().equals(datatype)) {
                result = dps1.getData().compareTo(dps2.getData());
            } else {
                log.warn((Object)"Can't compare data property statements: unsupported datatype.");
                return 0;
            }
        }
        return result;
    }
}

