/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller;

import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.publish.PublishObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.api.VitroApiServlet;
import edu.cornell.mannlib.vitro.webapp.controller.api.sparqlquery.InvalidQueryTypeException;
import edu.cornell.mannlib.vitro.webapp.controller.api.sparqlquery.RdfResultMediaType;
import edu.cornell.mannlib.vitro.webapp.controller.api.sparqlquery.SparqlQueryApiExecutor;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import edu.cornell.mannlib.vitro.webapp.utils.http.AcceptHeaderParsingException;
import edu.cornell.mannlib.vitro.webapp.utils.http.NotAcceptableException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;

public class IndividualListRdfController
extends VitroApiServlet {
    private static final Log log = LogFactory.getLog(IndividualListRdfController.class);
    private static final String QUERY_TEMPLATE = "CONSTRUCT { ?s a ?vclass . } WHERE { ?s a ?vclass . }";

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        try {
            String vclassUri = this.getVClassParameter(req);
            RdfResultMediaType mediaType = this.parseAcceptHeader(req);
            log.debug((Object)("Requested class is '" + vclassUri + "', media type is " + (Object)((Object)mediaType)));
            if (this.isVclassRestricted(vclassUri, req)) {
                this.sendEmptyModel(mediaType, resp);
            } else {
                this.executeQuery(this.buildQuery(vclassUri), mediaType.getContentType(), this.getRdfService(req), resp);
            }
        }
        catch (VitroApiServlet.BadParameterException e) {
            this.sendShortResponse(400, e.getMessage(), resp);
        }
        catch (AcceptHeaderParsingException | NotAcceptableException e) {
            this.sendShortResponse(406, "The accept header does not include any available content type.", e, resp);
        }
        catch (Exception e) {
            this.sendShortResponse(500, "Failed to obtain the list.", e, resp);
        }
    }

    private String getVClassParameter(HttpServletRequest req) throws VitroApiServlet.BadParameterException {
        String vclass = req.getParameter("vclass");
        if (vclass == null) {
            throw new VitroApiServlet.BadParameterException("vclass parameter was not supplied.");
        }
        if (vclass.trim().isEmpty()) {
            throw new VitroApiServlet.BadParameterException("vclass parameter is empty.");
        }
        return vclass;
    }

    private RdfResultMediaType parseAcceptHeader(HttpServletRequest req) throws NotAcceptableException, AcceptHeaderParsingException {
        String defaultType = RdfResultMediaType.RDF_XML.getContentType();
        Collection<String> availableTypes = RdfResultMediaType.contentTypes();
        String contentType = this.parseAcceptHeader(req, availableTypes, defaultType);
        return RdfResultMediaType.fromContentType(contentType);
    }

    private boolean isVclassRestricted(String vclassUri, HttpServletRequest req) {
        ObjectProperty property = new ObjectProperty();
        property.setURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        PublishObjectPropertyStatement dops = new PublishObjectPropertyStatement(ModelAccess.on(req).getOntModel("vitro:baseOntModel", new ModelAccess.LanguageOption[0]), RequestedAction.SOME_URI, property, vclassUri);
        return !PolicyHelper.isAuthorizedForActions(req, new AuthorizationRequest[]{dops});
    }

    private void sendEmptyModel(RdfResultMediaType mediaType, HttpServletResponse resp) throws IOException {
        resp.setContentType(mediaType.getContentType());
        Model m = ModelFactory.createDefaultModel();
        m.write((OutputStream)resp.getOutputStream(), mediaType.getJenaResponseFormat());
    }

    private String buildQuery(String vclassUri) {
        return QUERY_TEMPLATE.replace("?vclass", "<" + vclassUri + ">");
    }

    private RDFService getRdfService(HttpServletRequest req) {
        return RDFServiceUtils.getRDFService(new VitroRequest(req));
    }

    private void executeQuery(String query, String contentType, RDFService rdfService, HttpServletResponse resp) throws QueryParseException, NotAcceptableException, InvalidQueryTypeException, AcceptHeaderParsingException, RDFServiceException, IOException {
        SparqlQueryApiExecutor executor = SparqlQueryApiExecutor.instance(rdfService, query, contentType);
        resp.setContentType(executor.getMediaType());
        executor.executeAndFormat((OutputStream)resp.getOutputStream());
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doGet(req, res);
    }
}

