/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts;

import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.UserAccountsOrdering;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.UserAccountsSelection;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.UserAccountsSelectionCriteria;
import edu.cornell.mannlib.vitro.webapp.utils.sparql.SparqlQueryUtils;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.ResultSetParser;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.SparqlQueryRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;

public class UserAccountsSelector {
    private static final Log log = LogFactory.getLog(UserAccountsSelector.class);
    private static final String PREFIX_LINES = "PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX fn: <http://www.w3.org/2005/xpath-functions#> \nPREFIX auth: <http://vitro.mannlib.cornell.edu/ns/vitro/authorization#> \n";
    private static final String ALL_VARIABLES = "?uri ?email ?firstName ?lastName ?pwd ?expire ?count ?lastLogin ?status ?isRoot";
    private static final String COUNT_VARIABLE = "?uri";
    private static final String MAIN_QUERY_TEMPLATE = "%prefixes% \nSELECT DISTINCT %variables% \nWHERE {\n    %requiredClauses% \n    %optionalClauses% \n    %filterClauses% \n} \nORDER BY %ordering% \nLIMIT %limit% \nOFFSET %offset% \n";
    private static final String COUNT_QUERY_TEMPLATE = "%prefixes% \nSELECT count(DISTINCT %countVariable%) \nWHERE {\n    %requiredClauses% \n    %optionalClauses% \n    %filterClauses% \n} \n";
    private static final String PERMISSIONS_QUERY_TEMPLATE = "%prefixes% \nSELECT ?ps \nWHERE {\n    <%uri%> auth:hasPermissionSet ?ps \n} \n";
    private final OntModel model;
    private final UserAccountsSelectionCriteria criteria;

    public static UserAccountsSelection select(OntModel userAccountsModel, UserAccountsSelectionCriteria criteria) {
        return new UserAccountsSelector(userAccountsModel, criteria).select();
    }

    public UserAccountsSelector(OntModel userAccountsModel, UserAccountsSelectionCriteria criteria) {
        if (userAccountsModel == null) {
            throw new NullPointerException("userAccountsModel may not be null.");
        }
        this.model = userAccountsModel;
        if (criteria == null) {
            throw new NullPointerException("criteria may not be null.");
        }
        this.criteria = criteria;
    }

    public UserAccountsSelection select() {
        List<UserAccount> accounts = this.queryForAccounts();
        int resultCount = this.queryForCount();
        this.queryToPopulatePermissionSets(accounts);
        return new UserAccountsSelection(this.criteria, accounts, resultCount);
    }

    private List<UserAccount> queryForAccounts() {
        String qString = MAIN_QUERY_TEMPLATE.replace("%prefixes%", PREFIX_LINES).replace("%variables%", ALL_VARIABLES).replace("%requiredClauses%", this.requiredClauses()).replace("%optionalClauses%", this.optionalClauses()).replace("%filterClauses%", this.filterClauses()).replace("%ordering%", this.ordering()).replace("%limit%", this.limit()).replace("%offset%", this.offset());
        log.debug((Object)("main query: " + qString));
        List<UserAccount> accounts = SparqlQueryRunner.createSelectQueryContext((Model)this.model, qString).execute().parse(new MainQueryParser());
        log.debug((Object)("query returns: " + accounts));
        return accounts;
    }

    private int queryForCount() {
        String qString = COUNT_QUERY_TEMPLATE.replace("%prefixes%", PREFIX_LINES).replace("%countVariable%", COUNT_VARIABLE).replace("%requiredClauses%", this.requiredClauses()).replace("%optionalClauses%", this.optionalClauses()).replace("%filterClauses%", this.filterClauses());
        log.debug((Object)("count query: " + qString));
        int count = SparqlQueryRunner.createSelectQueryContext((Model)this.model, qString).execute().parse(new CountQueryParser());
        log.debug((Object)("result count: " + count));
        return count;
    }

    private void queryToPopulatePermissionSets(List<UserAccount> accounts) {
        for (UserAccount account : accounts) {
            String uri = account.getUri();
            String qString = PERMISSIONS_QUERY_TEMPLATE.replace("%prefixes%", PREFIX_LINES).replace("%uri%", uri);
            log.debug((Object)("permissions query: " + qString));
            Set<String> permissions = SparqlQueryRunner.createSelectQueryContext((Model)this.model, qString).execute().parse(new PermissionsQueryParser());
            log.debug((Object)("permissions for '" + uri + "': " + permissions));
            account.setPermissionSetUris(permissions);
        }
    }

    private String requiredClauses() {
        return "?uri a auth:UserAccount ; \n         auth:emailAddress ?email .";
    }

    private String optionalClauses() {
        return "OPTIONAL { ?uri auth:firstName ?firstName } \n    OPTIONAL { ?uri auth:lastName ?lastName } \n    OPTIONAL { ?uri auth:md5password ?pwd } \n    OPTIONAL { ?uri auth:passwordChangeExpires ?expire } \n    OPTIONAL { ?uri auth:loginCount ?count } \n    OPTIONAL { ?uri auth:lastLoginTime ?lastLogin } \n    OPTIONAL { ?uri auth:status ?status } \n    OPTIONAL { ?uri ?isRoot auth:RootUserAccount }";
    }

    private String filterClauses() {
        String clean;
        String filters = "";
        String roleFilterUri = this.criteria.getRoleFilterUri();
        String searchTerm = this.criteria.getSearchTerm();
        if (!roleFilterUri.isEmpty()) {
            clean = SparqlQueryUtils.escapeForRegex(roleFilterUri);
            filters = filters + "OPTIONAL { ?uri auth:hasPermissionSet ?role } \n    FILTER (REGEX(str(?role), '^" + clean + "$'))";
        }
        if (!roleFilterUri.isEmpty() && !searchTerm.isEmpty()) {
            filters = filters + " \n    ";
        }
        if (!searchTerm.isEmpty()) {
            clean = SparqlQueryUtils.escapeForRegex(searchTerm);
            filters = filters + "FILTER (" + "REGEX(?email, '" + clean + "', 'i')" + " || " + "REGEX(fn:concat(?firstName, ' ', ?lastName), '" + clean + "', 'i')" + ")";
        }
        return filters;
    }

    private String ordering() {
        UserAccountsOrdering orderBy = this.criteria.getOrderBy();
        String keyword = orderBy.getDirection().keyword;
        String variable = orderBy.getField().name;
        if (orderBy.getField() == UserAccountsOrdering.Field.EMAIL) {
            return keyword + "(?" + variable + ")";
        }
        return keyword + "(?" + variable + ") ?" + UserAccountsOrdering.Field.EMAIL.name;
    }

    private String limit() {
        return String.valueOf(this.criteria.getAccountsPerPage());
    }

    private String offset() {
        int offset = this.criteria.getAccountsPerPage() * (this.criteria.getPageIndex() - 1);
        return String.valueOf(offset);
    }

    private static class PermissionsQueryParser
    extends ResultSetParser<Set<String>> {
        private PermissionsQueryParser() {
        }

        @Override
        protected Set<String> defaultValue() {
            return Collections.emptySet();
        }

        @Override
        protected Set<String> parseResults(String queryStr, ResultSet results) {
            HashSet<String> permissions = new HashSet<String>();
            while (results.hasNext()) {
                try {
                    QuerySolution solution = results.next();
                    Resource r = solution.getResource("ps");
                    if (r == null) continue;
                    permissions.add(r.getURI());
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to parse the query result: " + queryStr), (Throwable)e);
                }
            }
            return permissions;
        }
    }

    private static class CountQueryParser
    extends ResultSetParser<Integer> {
        private CountQueryParser() {
        }

        @Override
        protected Integer defaultValue() {
            return 0;
        }

        @Override
        protected Integer parseResults(String queryStr, ResultSet results) {
            int count = 0;
            if (!results.hasNext()) {
                log.warn((Object)"count query returned no results.");
            }
            try {
                QuerySolution solution = results.next();
                count = this.ifIntPresent(solution, ".1", 0);
            }
            catch (Exception e) {
                log.warn((Object)("Failed to parse the query result" + queryStr), (Throwable)e);
            }
            return count;
        }
    }

    private static class MainQueryParser
    extends ResultSetParser<List<UserAccount>> {
        private MainQueryParser() {
        }

        @Override
        protected List<UserAccount> defaultValue() {
            return Collections.emptyList();
        }

        @Override
        protected List<UserAccount> parseResults(String queryStr, ResultSet results) {
            ArrayList<UserAccount> accounts = new ArrayList<UserAccount>();
            while (results.hasNext()) {
                try {
                    QuerySolution solution = results.next();
                    UserAccount user = this.parseSolution(solution);
                    accounts.add(user);
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to parse the query result: " + queryStr), (Throwable)e);
                }
            }
            return accounts;
        }

        private UserAccount parseSolution(QuerySolution solution) {
            UserAccount user = new UserAccount();
            user.setUri(this.getUriFromSolution(solution));
            user.setEmailAddress(solution.getLiteral("email").getString());
            user.setFirstName(this.ifLiteralPresent(solution, "firstName", ""));
            user.setLastName(this.ifLiteralPresent(solution, "lastName", ""));
            user.setMd5Password(this.ifLiteralPresent(solution, "pwd", ""));
            user.setPasswordLinkExpires(this.ifLongPresent(solution, "expire", 0L));
            user.setLoginCount(this.ifIntPresent(solution, "count", 0));
            user.setLastLoginTime(this.ifLongPresent(solution, "lastLogin", 0L));
            user.setStatus(this.parseStatus(solution, "status", null));
            user.setRootUser(solution.contains("isRoot"));
            return user;
        }

        private UserAccount.Status parseStatus(QuerySolution solution, String variableName, UserAccount.Status defaultValue) {
            Literal literal = solution.getLiteral(variableName);
            if (literal == null) {
                return defaultValue;
            }
            String string = literal.getString();
            try {
                return UserAccount.Status.valueOf(string);
            }
            catch (Exception e) {
                String uri = this.getUriFromSolution(solution);
                log.warn((Object)("Failed to parse the status value for '" + uri + "': '" + string + "'"));
                return defaultValue;
            }
        }

        private String getUriFromSolution(QuerySolution solution) {
            return solution.getResource("uri").getURI();
        }
    }
}

