/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.accounts.user;

import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.UserAccountsPage;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.user.UserAccountsFirstTimeExternalPageStrategy;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.Authenticator;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import java.util.Collections;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;

public class UserAccountsFirstTimeExternalPage
extends UserAccountsPage {
    private static final String PARAMETER_SUBMIT = "submit";
    private static final String PARAMETER_EXTERNAL_AUTH_ID = "externalAuthId";
    private static final String PARAMETER_AFTER_LOGIN_URL = "afterLoginUrl";
    private static final String PARAMETER_EMAIL_ADDRESS = "emailAddress";
    private static final String PARAMETER_FIRST_NAME = "firstName";
    private static final String PARAMETER_LAST_NAME = "lastName";
    private static final String ERROR_NO_EMAIL = "errorEmailIsEmpty";
    private static final String ERROR_EMAIL_IN_USE = "errorEmailInUse";
    private static final String ERROR_EMAIL_INVALID_FORMAT = "errorEmailInvalidFormat";
    private static final String ERROR_NO_FIRST_NAME = "errorFirstNameIsEmpty";
    private static final String ERROR_NO_LAST_NAME = "errorLastNameIsEmpty";
    private static final String TEMPLATE_NAME = "userAccounts-firstTimeExternal.ftl";
    private static final String ATTRIBUTE_EXTERNAL_LOGIN_INFO = UserAccountsFirstTimeExternalPage.class.getName();
    private final UserAccountsFirstTimeExternalPageStrategy strategy;
    private String externalAuthId = "";
    private String afterLoginUrl = "";
    private boolean submit = false;
    private String emailAddress = "";
    private String firstName = "";
    private String lastName = "";
    private String errorCode = "";
    private String bogusMessage = "";

    public static void setExternalLoginInfo(HttpServletRequest req, String externalAuthId, String afterLoginUrl) {
        req.getSession().setAttribute(ATTRIBUTE_EXTERNAL_LOGIN_INFO, (Object)new ExternalLoginInfo(externalAuthId, afterLoginUrl));
    }

    protected UserAccountsFirstTimeExternalPage(VitroRequest vreq) {
        super(vreq);
        this.strategy = UserAccountsFirstTimeExternalPageStrategy.getInstance(vreq, this, this.isEmailEnabled());
        this.checkSessionForExternalLoginInfo();
        if (this.externalAuthId.isEmpty()) {
            this.parseRequestParameters();
        }
        this.validateExternalAuthId();
        if (this.isSubmit() && !this.isBogus()) {
            this.validateParameters();
        }
    }

    private void checkSessionForExternalLoginInfo() {
        HttpSession session = this.vreq.getSession();
        Object o = session.getAttribute(ATTRIBUTE_EXTERNAL_LOGIN_INFO);
        session.removeAttribute(ATTRIBUTE_EXTERNAL_LOGIN_INFO);
        if (o instanceof ExternalLoginInfo) {
            this.externalAuthId = ((ExternalLoginInfo)o).externalAuthId;
            this.afterLoginUrl = ((ExternalLoginInfo)o).afterLoginUrl;
            if (this.afterLoginUrl == null) {
                this.afterLoginUrl = "";
            }
        }
    }

    private void parseRequestParameters() {
        this.externalAuthId = this.getStringParameter(PARAMETER_EXTERNAL_AUTH_ID, "");
        this.afterLoginUrl = this.getStringParameter(PARAMETER_AFTER_LOGIN_URL, "");
        this.submit = this.isFlagOnRequest(PARAMETER_SUBMIT);
        this.emailAddress = this.getStringParameter(PARAMETER_EMAIL_ADDRESS, "");
        this.firstName = this.getStringParameter(PARAMETER_FIRST_NAME, "");
        this.lastName = this.getStringParameter(PARAMETER_LAST_NAME, "");
    }

    private void validateExternalAuthId() {
        if (this.externalAuthId.isEmpty()) {
            this.bogusMessage = this.i18n.text("external_id_not_provided", new Object[0]);
            return;
        }
        if (null != this.userAccountsDao.getUserAccountByExternalAuthId(this.externalAuthId)) {
            this.bogusMessage = this.i18n.text("external_id_already_in_use", this.externalAuthId);
            return;
        }
        if (!Authenticator.getInstance((HttpServletRequest)this.vreq).isUserPermittedToLogin(null)) {
            this.bogusMessage = this.i18n.text("logins_disabled_for_maintenance", new Object[0]);
            return;
        }
    }

    public boolean isBogus() {
        return !this.bogusMessage.isEmpty();
    }

    public String getBogusMessage() {
        return this.bogusMessage;
    }

    public boolean isSubmit() {
        return this.submit;
    }

    private void validateParameters() {
        if (this.firstName.isEmpty()) {
            this.errorCode = ERROR_NO_FIRST_NAME;
        } else if (this.lastName.isEmpty()) {
            this.errorCode = ERROR_NO_LAST_NAME;
        } else if (this.emailAddress.isEmpty()) {
            this.errorCode = ERROR_NO_EMAIL;
        } else if (this.isEmailInUse()) {
            this.errorCode = ERROR_EMAIL_IN_USE;
        } else if (!this.isEmailValidFormat()) {
            this.errorCode = ERROR_EMAIL_INVALID_FORMAT;
        }
    }

    private boolean isEmailInUse() {
        return this.userAccountsDao.getUserAccountByEmail(this.emailAddress) != null;
    }

    private boolean isEmailValidFormat() {
        return Authenticator.isValidEmailAddress(this.emailAddress);
    }

    public boolean isValid() {
        return this.errorCode.isEmpty();
    }

    public final ResponseValues showPage() {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put(PARAMETER_EXTERNAL_AUTH_ID, this.externalAuthId);
        body.put(PARAMETER_AFTER_LOGIN_URL, this.afterLoginUrl);
        body.put(PARAMETER_EMAIL_ADDRESS, this.emailAddress);
        body.put(PARAMETER_FIRST_NAME, this.firstName);
        body.put(PARAMETER_LAST_NAME, this.lastName);
        body.put("formUrls", this.buildUrlsMap());
        if (!this.errorCode.isEmpty()) {
            body.put(this.errorCode, Boolean.TRUE);
        }
        this.strategy.addMoreBodyValues(body);
        return new TemplateResponseValues(TEMPLATE_NAME, body);
    }

    public UserAccount createAccount() {
        UserAccount u = new UserAccount();
        u.setEmailAddress(this.emailAddress);
        u.setFirstName(this.firstName);
        u.setLastName(this.lastName);
        u.setExternalAuthId(this.externalAuthId);
        u.setPasswordChangeRequired(false);
        u.setPasswordLinkExpires(0L);
        u.setExternalAuthOnly(true);
        u.setLoginCount(0);
        u.setStatus(UserAccount.Status.ACTIVE);
        u.setPermissionSetUris(Collections.singleton("http://vitro.mannlib.cornell.edu/ns/vitro/authorization#SELF_EDITOR"));
        this.userAccountsDao.insertUserAccount(u);
        this.strategy.notifyUser(u);
        return u;
    }

    public String getAfterLoginUrl() {
        if (StringUtils.isEmpty((CharSequence)this.afterLoginUrl)) {
            return null;
        }
        return this.afterLoginUrl;
    }

    private static class ExternalLoginInfo {
        final String externalAuthId;
        final String afterLoginUrl;

        public ExternalLoginInfo(String externalAuthId, String afterLoginUrl) {
            this.externalAuthId = externalAuthId;
            this.afterLoginUrl = afterLoginUrl;
        }
    }
}

