/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.admin;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.AbstractPageHandler;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.Authenticator;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.BasicAuthenticator;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.RestrictedAuthenticator;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;

public class RestrictLoginsController
extends FreemarkerHttpServlet {
    public static final String PARAMETER_RESTRICT = "restrict";
    public static final String PARAMETER_OPEN = "open";
    public static final String MESSAGE_NO_MESSAGE = "message";
    public static final String MESSAGE_RESTRICTING = "messageRestricting";
    public static final String MESSAGE_OPENING = "messageOpening";
    public static final String MESSAGE_ALREADY_RESTRICTED = "messageAlreadyRestricted";
    public static final String MESSAGE_ALREADY_OPEN = "messageAlreadyOpen";

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.LOGIN_DURING_MAINTENANCE.ACTION;
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        Core pageHandler = new Core(vreq);
        pageHandler.processInput();
        return pageHandler.prepareOutput();
    }

    private static class Core
    extends AbstractPageHandler {
        private String messageCode;

        Core(VitroRequest vreq) {
            super(vreq);
        }

        void processInput() {
            State desired = this.figureDesiredState();
            State current = this.figureCurrentlyState();
            if (desired == null) {
                this.messageCode = RestrictLoginsController.MESSAGE_NO_MESSAGE;
            } else if (desired == State.OPEN) {
                if (current == State.OPEN) {
                    this.messageCode = RestrictLoginsController.MESSAGE_ALREADY_OPEN;
                } else {
                    this.openLogins();
                    this.messageCode = RestrictLoginsController.MESSAGE_OPENING;
                }
            } else if (desired == State.RESTRICTED) {
                if (current == State.RESTRICTED) {
                    this.messageCode = RestrictLoginsController.MESSAGE_ALREADY_RESTRICTED;
                } else {
                    this.restrictLogins();
                    this.messageCode = RestrictLoginsController.MESSAGE_RESTRICTING;
                }
            }
        }

        ResponseValues prepareOutput() {
            boolean restricted = this.figureCurrentlyState() == State.RESTRICTED;
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("title", I18n.text((HttpServletRequest)this.vreq, "restrict_logins", new Object[0]));
            body.put("restricted", restricted);
            if (!RestrictLoginsController.MESSAGE_NO_MESSAGE.equals(this.messageCode)) {
                body.put(this.messageCode, Boolean.TRUE);
            }
            body.put("restrictUrl", UrlBuilder.getUrl("/admin/restrictLogins", RestrictLoginsController.PARAMETER_RESTRICT, "true"));
            body.put("openUrl", UrlBuilder.getUrl("/admin/restrictLogins", RestrictLoginsController.PARAMETER_OPEN, "true"));
            return new TemplateResponseValues("admin-restrictLogins.ftl", body);
        }

        private State figureDesiredState() {
            if (this.isFlagOnRequest(RestrictLoginsController.PARAMETER_RESTRICT)) {
                return State.RESTRICTED;
            }
            if (this.isFlagOnRequest(RestrictLoginsController.PARAMETER_OPEN)) {
                return State.OPEN;
            }
            return null;
        }

        private State figureCurrentlyState() {
            Authenticator auth = Authenticator.getInstance((HttpServletRequest)this.vreq);
            if (auth instanceof RestrictedAuthenticator) {
                return State.RESTRICTED;
            }
            return State.OPEN;
        }

        private void openLogins() {
            Authenticator.setAuthenticatorFactory(new BasicAuthenticator.Factory(), this.ctx);
        }

        private void restrictLogins() {
            Authenticator.setAuthenticatorFactory(new RestrictedAuthenticator.Factory(), this.ctx);
        }

        private static enum State {
            OPEN,
            RESTRICTED;

        }
    }
}

