/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.admin;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.i18n.I18n;
import edu.cornell.mannlib.vitro.webapp.startup.StartupStatus;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;

public class StartupStatusController
extends FreemarkerHttpServlet {
    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.SEE_STARTUP_STATUS.ACTION;
    }

    @Override
    protected ResponseValues processRequest(VitroRequest vreq) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("title", I18n.text((HttpServletRequest)vreq, "startup_status", new Object[0]));
        body.put("status", StartupStatus.getBean(this.getServletContext()));
        body.put("contextPath", this.getContextPath());
        body.put("applicationName", this.getApplicationName(vreq));
        return new TemplateResponseValues("startupStatus-display.ftl", body);
    }

    private String getContextPath() {
        String cp = this.getServletContext().getContextPath();
        if (cp == null || cp.isEmpty()) {
            return "The application";
        }
        return cp;
    }

    private Object getApplicationName(VitroRequest vreq) {
        String name = "";
        try {
            name = vreq.getAppBean().getApplicationName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (name != null && !name.isEmpty()) {
            return name;
        }
        return this.getContextPath();
    }
}

