/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.ajax;

import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.ajax.SparqlUtils;
import edu.cornell.mannlib.vitro.webapp.controller.ajax.VitroAjaxController;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.Query;
import org.apache.jena.rdf.model.Model;

public class SparqlQueryAjaxController
extends VitroAjaxController {
    private static final Log log = LogFactory.getLog(SparqlQueryAjaxController.class);
    public static final String PARAMETER_QUERY = "query";
    public static final String RESPONSE_MIME_TYPE = "application/javascript";
    public static final String PARAMETER_MODEL = "model";
    public static final String OPTION_MODEL_FULL = "full";
    public static final String OPTION_MODEL_USER_ACCOUNTS = "userAccounts";

    @Override
    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        String modelParam = this.getModelParam((HttpServletRequest)vreq);
        if (OPTION_MODEL_USER_ACCOUNTS.equals(modelParam)) {
            return SimplePermission.QUERY_USER_ACCOUNTS_MODEL.ACTION;
        }
        return SimplePermission.QUERY_FULL_MODEL.ACTION;
    }

    @Override
    protected void doRequest(VitroRequest vreq, HttpServletResponse response) throws ServletException, IOException {
        try {
            String modelParam = this.getModelParam((HttpServletRequest)vreq);
            Model model = this.locateModel(vreq, modelParam);
            String queryParam = this.locateQueryParam(vreq);
            Query query = SparqlUtils.createQuery(queryParam);
            SparqlUtils.executeQuery(response, query, model);
            return;
        }
        catch (SparqlUtils.AjaxControllerException e) {
            log.error((Object)e.getMessage());
            response.sendError(e.getStatusCode());
            return;
        }
    }

    private String getModelParam(HttpServletRequest req) {
        String modelParam = req.getParameter(PARAMETER_MODEL);
        log.debug((Object)("modelParam was: " + modelParam));
        if (modelParam != null && !modelParam.isEmpty()) {
            return modelParam;
        }
        return OPTION_MODEL_FULL;
    }

    private Model locateModel(VitroRequest vreq, String modelParam) {
        if (OPTION_MODEL_USER_ACCOUNTS.equals(modelParam)) {
            return ModelAccess.on((HttpServletRequest)vreq).getOntModel("http://vitro.mannlib.cornell.edu/default/vitro-kb-userAccounts", new ModelAccess.LanguageOption[0]);
        }
        return ModelAccess.on((HttpServletRequest)vreq).getOntModel(new ModelAccess.LanguageOption[0]);
    }

    private String locateQueryParam(VitroRequest vreq) throws SparqlUtils.AjaxControllerException {
        String queryParam = vreq.getParameter(PARAMETER_QUERY);
        log.debug((Object)("queryParam was: " + queryParam));
        if (queryParam != null && !queryParam.isEmpty()) {
            return queryParam;
        }
        throw new SparqlUtils.AjaxControllerException(404, "'query' parameter is required");
    }
}

