/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.authenticate;

import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.beans.DisplayMessage;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.accounts.user.UserAccountsFirstTimeExternalPage;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.Authenticator;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.BaseLoginServlet;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.ExternalAuthHelper;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.LoginExternalAuthSetup;
import edu.cornell.mannlib.vitro.webapp.controller.authenticate.LoginRedirector;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.login.LoginProcessBean;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginExternalAuthReturn
extends BaseLoginServlet {
    private static final Log log = LogFactory.getLog(LoginExternalAuthReturn.class);

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (log.isDebugEnabled()) {
            Enumeration names = req.getHeaderNames();
            log.debug((Object)("------------request:" + req.getRequestURL()));
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                log.debug((Object)(name + "=" + req.getHeader(name)));
            }
        }
        String externalAuthId = ExternalAuthHelper.getHelper((ServletRequest)req).getExternalAuthId(req);
        log.debug((Object)("externalAuthID='" + externalAuthId + "'"));
        if (externalAuthId == null) {
            this.complainAndReturnToReferrer(req, resp, LoginExternalAuthSetup.ATTRIBUTE_REFERRER, LoginExternalAuthReturn.messageLoginFailed(req));
            return;
        }
        String afterLoginUrl = LoginProcessBean.getBean(req).getAfterLoginUrl();
        this.removeLoginProcessArtifacts(req);
        UserAccount userAccount = this.getAuthenticator(req).getAccountForExternalAuth(externalAuthId);
        if (!this.getAuthenticator(req).isUserPermittedToLogin(userAccount)) {
            log.debug((Object)("Logins disabled for " + userAccount));
            this.complainAndReturnToReferrer(req, resp, LoginExternalAuthSetup.ATTRIBUTE_REFERRER, LoginExternalAuthReturn.messageLoginDisabled(req));
            return;
        }
        if (userAccount == null) {
            log.debug((Object)("Creating new account for " + externalAuthId + ", return to '" + afterLoginUrl + "'"));
            UserAccountsFirstTimeExternalPage.setExternalLoginInfo(req, externalAuthId, afterLoginUrl);
            resp.sendRedirect(UrlBuilder.getUrl("/accounts/firstTimeExternal"));
            return;
        }
        try {
            log.debug((Object)("Logging in as " + userAccount.getUri()));
            this.getAuthenticator(req).recordLoginAgainstUserAccount(userAccount, LoginStatusBean.AuthenticationSource.EXTERNAL);
            new LoginRedirector(req, afterLoginUrl).redirectLoggedInUser(resp);
            return;
        }
        catch (Authenticator.LoginNotPermitted e) {
            log.debug((Object)("Logins disabled for " + userAccount));
            this.complainAndReturnToReferrer(req, resp, LoginExternalAuthSetup.ATTRIBUTE_REFERRER, LoginExternalAuthReturn.messageLoginDisabled(req));
            return;
        }
    }

    @Override
    protected void complainAndReturnToReferrer(HttpServletRequest req, HttpServletResponse resp, String sessionAttributeForReferrer, LoginProcessBean.Message message) throws IOException {
        DisplayMessage.setMessage(req, message.getText());
        super.complainAndReturnToReferrer(req, resp, sessionAttributeForReferrer, message);
    }

    private void removeLoginProcessArtifacts(HttpServletRequest req) {
        req.getSession().removeAttribute(LoginExternalAuthSetup.ATTRIBUTE_REFERRER);
        LoginProcessBean.removeBean(req);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }
}

