/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.datatools.dumprestore;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.JsonObject;
import javax.json.JsonString;
import org.apache.jena.atlas.lib.EscapeStr;

public abstract class DumpNode {
    private static final String PATTERN_NQUAD_URI = "<(.+)>";
    private static final String PATTERN_NQUAD_LITERAL = "\"(.*)\"(@(.+))?(\\^\\^<(.+)>)?";
    private static final String PATTERN_NQUAD_BLANK = "_:(.+)";

    public static DumpNode fromJson(JsonObject json) throws BadNodeException {
        String type;
        if (json == null) {
            return new DumpNullNode();
        }
        switch (type = DumpNode.getString(json, "type")) {
            case "uri": {
                return new DumpUriNode(DumpNode.getString(json, "value"));
            }
            case "literal": 
            case "typed-literal": {
                return new DumpLiteralNode(DumpNode.getString(json, "value"), DumpNode.getString(json, "xml:lang"), DumpNode.getString(json, "datatype"));
            }
            case "bnode": {
                return new DumpBlankNode(DumpNode.getString(json, "value"));
            }
        }
        throw new BadNodeException("Unrecognized type: '" + type + "'");
    }

    public static DumpNode fromNquad(String text) throws BadNodeException {
        if (text == null) {
            return new DumpNullNode();
        }
        if ((text = text.trim()).isEmpty()) {
            return new DumpNullNode();
        }
        Matcher m1 = Pattern.compile(PATTERN_NQUAD_URI).matcher(text);
        Matcher m2 = Pattern.compile(PATTERN_NQUAD_LITERAL).matcher(text);
        Matcher m3 = Pattern.compile(PATTERN_NQUAD_BLANK).matcher(text);
        if (m1.matches()) {
            return new DumpUriNode(DumpNode.unescape(m1.group(1)));
        }
        if (m2.matches()) {
            return new DumpLiteralNode(DumpNode.unescape(m2.group(1)), DumpNode.unescape(m2.group(3)), DumpNode.unescape(m2.group(5)));
        }
        if (m3.matches()) {
            return new DumpBlankNode(DumpNode.unescape(m3.group(1)));
        }
        throw new BadNodeException("Can't parse node: '" + text + "'");
    }

    private static String unescape(String s) {
        return s == null ? null : EscapeStr.unescapeStr((String)s);
    }

    private static String getString(JsonObject json, String name) {
        JsonString jsString = json.getJsonString(name);
        return jsString == null ? null : json.getString(name);
    }

    public abstract String getValue();

    public abstract String toNquad();

    public boolean isNull() {
        return false;
    }

    public boolean isUri() {
        return false;
    }

    public boolean isLiteral() {
        return false;
    }

    public boolean isBlank() {
        return false;
    }

    public static class BadNodeException
    extends Exception {
        public BadNodeException(String message) {
            super(message);
        }

        public BadNodeException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class DumpBlankNode
    extends DumpNode {
        private final String label;

        private DumpBlankNode(String label) throws BadNodeException {
            if (label == null) {
                throw new BadNodeException("label may not be null.");
            }
            this.label = label;
        }

        @Override
        public boolean isBlank() {
            return true;
        }

        @Override
        public String getValue() {
            return this.label;
        }

        @Override
        public String toNquad() {
            return "_:" + this.label;
        }
    }

    public static class DumpLiteralNode
    extends DumpNode {
        private final String value;
        private final String language;
        private final String datatype;

        private DumpLiteralNode(String value, String language, String datatype) throws BadNodeException {
            if (value == null) {
                throw new BadNodeException("value may not be null.");
            }
            if (language != null && datatype != null) {
                throw new BadNodeException("either language('" + language + "') or datatype('" + datatype + "') must be null.");
            }
            this.value = value;
            this.language = language;
            this.datatype = datatype;
        }

        @Override
        public boolean isLiteral() {
            return true;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String toNquad() {
            String valueString = "\"" + EscapeStr.stringEsc((String)this.value) + "\"";
            if (this.language != null) {
                return valueString + "@" + this.language;
            }
            if (this.datatype != null) {
                return valueString + "^^<" + EscapeStr.stringEsc((String)this.datatype) + ">";
            }
            return valueString;
        }
    }

    public static class DumpUriNode
    extends DumpNode {
        private final String uri;

        private DumpUriNode(String uri) throws BadNodeException {
            if (uri == null) {
                throw new BadNodeException("uri may not be null.");
            }
            this.uri = uri;
        }

        @Override
        public boolean isUri() {
            return true;
        }

        @Override
        public String getValue() {
            return this.uri;
        }

        @Override
        public String toNquad() {
            return "<" + EscapeStr.stringEsc((String)this.uri) + ">";
        }
    }

    public static class DumpNullNode
    extends DumpNode {
        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public String getValue() {
            return null;
        }

        @Override
        public String toNquad() {
            return "";
        }
    }
}

