/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.datatools.dumprestore;

import edu.cornell.mannlib.vitro.webapp.controller.datatools.dumprestore.DumpNode;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class NQuadLineSplitter {
    private static final Log log = LogFactory.getLog(NQuadLineSplitter.class);
    private final String line;
    private final List<String> pieces = new ArrayList<String>();
    private int i;

    public NQuadLineSplitter(String line) throws DumpNode.BadNodeException {
        this.line = line;
        block6: while (!this.atEnd()) {
            this.advancePastWhiteSpace();
            switch (line.charAt(this.i)) {
                case '#': {
                    this.advancePastComment();
                    continue block6;
                }
                case '<': 
                case '_': {
                    this.scanUnquotedString();
                    continue block6;
                }
                case '\"': {
                    this.scanLiteralString();
                    continue block6;
                }
                case '.': {
                    this.assureEndOfLine();
                    continue block6;
                }
            }
            throw new DumpNode.BadNodeException("found unexpected character at position " + this.i + " of line '" + line + "'");
        }
    }

    private boolean atEnd() {
        return this.i >= this.line.length();
    }

    private boolean isWhiteSpace() {
        return " \t\r\n".indexOf(this.line.charAt(this.i)) >= 0;
    }

    private void advancePastWhiteSpace() {
        while (!this.atEnd() && this.isWhiteSpace()) {
            ++this.i;
        }
    }

    private void advancePastComment() {
        this.i = this.line.length();
    }

    private void scanUnquotedString() {
        int start = this.i;
        while (!this.atEnd() && !this.isWhiteSpace()) {
            ++this.i;
        }
        this.pieces.add(this.line.substring(start, this.i));
    }

    private void scanLiteralString() {
        int start = this.i;
        boolean inQuotes = false;
        while (!(this.atEnd() || !inQuotes && this.isWhiteSpace())) {
            if (this.isQuote()) {
                inQuotes = !inQuotes;
                log.debug((Object)("column " + this.i + ", inQuotes=" + inQuotes));
            }
            ++this.i;
        }
        this.pieces.add(this.line.substring(start, this.i));
    }

    private void assureEndOfLine() throws DumpNode.BadNodeException {
        ++this.i;
        while (!this.atEnd() && this.isWhiteSpace()) {
            ++this.i;
        }
        if (this.atEnd()) {
            return;
        }
        if (this.line.charAt(this.i) == '#') {
            return;
        }
        throw new DumpNode.BadNodeException("Period was not followed by end of line: '" + this.line + "'");
    }

    private boolean isQuote() {
        boolean isEscaped = this.i > 0 && this.line.charAt(this.i - 1) == '\\';
        return this.line.charAt(this.i) == '\"' && !isEscaped;
    }

    public List<String> split() {
        return this.pieces;
    }
}

